/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.map.impl.client.MapPutRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MapReplaceIfSameRequest
extends MapPutRequest {
    private Data testValue;

    public MapReplaceIfSameRequest() {
    }

    public MapReplaceIfSameRequest(String name, Data key, Data testValue, Data value, long threadId) {
        super(name, key, value, threadId);
        this.testValue = testValue;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation op = this.getOperationProvider().createReplaceIfSameOperation(this.name, this.key, this.testValue, this.value);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.testValue);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.testValue = in.readData();
    }

    @Override
    public String getMethodName() {
        return "replace";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.testValue, this.value};
    }
}

