/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.IQueue;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;

@ManagedDescription(value="IQueue")
public class QueueMBean
extends HazelcastMBean<IQueue> {
    protected QueueMBean(IQueue managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("IQueue", managedObject.getName());
    }

    @ManagedAnnotation(value="localOwnedItemCount")
    @ManagedDescription(value="the number of owned items in this member.")
    public long getLocalOwnedItemCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOwnedItemCount();
    }

    @ManagedAnnotation(value="localBackupItemCount")
    @ManagedDescription(value="the number of backup items in this member.")
    public long getLocalBackupItemCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getBackupItemCount();
    }

    @ManagedAnnotation(value="localMinAge")
    @ManagedDescription(value="the min age of the items in this member.")
    public long getLocalMinAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getMinAge();
    }

    @ManagedAnnotation(value="localMaxAge")
    @ManagedDescription(value="the max age of the items in this member.")
    public long getLocalMaxAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getMaxAge();
    }

    @ManagedAnnotation(value="localAvgAge")
    @ManagedDescription(value="the average age of the items in this member.")
    public long getLocalAvgAge() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getAvgAge();
    }

    @ManagedAnnotation(value="localOfferOperationCount")
    @ManagedDescription(value="the number of offer/put/add operations in this member")
    public long getLocalOfferOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOfferOperationCount();
    }

    @ManagedAnnotation(value="localRejectedOfferOperationCount")
    @ManagedDescription(value="the number of rejected offers in this member")
    public long getLocalRejectedOfferOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getRejectedOfferOperationCount();
    }

    @ManagedAnnotation(value="localPollOperationCount")
    @ManagedDescription(value="the number of poll/take/remove operations in this member")
    public long getLocalPollOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getPollOperationCount();
    }

    @ManagedAnnotation(value="localEmptyPollOperationCount")
    @ManagedDescription(value="number of null returning poll operations in this member")
    public long getLocalEmptyPollOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getEmptyPollOperationCount();
    }

    @ManagedAnnotation(value="localOtherOperationsCount")
    @ManagedDescription(value="number of other operations in this member")
    public long getLocalOtherOperationsCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getOtherOperationsCount();
    }

    @ManagedAnnotation(value="localEventOperationCount")
    @ManagedDescription(value="number of event operations in this member")
    public long getLocalEventOperationCount() {
        return ((IQueue)this.managedObject).getLocalQueueStats().getEventOperationCount();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((IQueue)this.managedObject).getName();
    }

    @ManagedAnnotation(value="partitionKey")
    @ManagedDescription(value="the partitionKey")
    public String getPartitionKey() {
        return ((IQueue)this.managedObject).getPartitionKey();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="QueueConfig")
    public String getConfig() {
        String managedObjectName = ((IQueue)this.managedObject).getName();
        Config config = this.service.instance.getConfig();
        QueueConfig queueConfig = config.findQueueConfig(managedObjectName);
        return queueConfig.toString();
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Queue")
    public void clear() {
        ((IQueue)this.managedObject).clear();
    }
}

