/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LoadAllOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation {
    private List<Data> keys;
    private boolean replaceExistingValues;
    private boolean withUserSuppliedKeys;

    public LoadAllOperation() {
        this.keys = Collections.emptyList();
    }

    public LoadAllOperation(String name, List<Data> keys, boolean replaceExistingValues, boolean withUserSuppliedKeys) {
        super(name);
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
        this.withUserSuppliedKeys = withUserSuppliedKeys;
        this.setFlag(withUserSuppliedKeys, 128);
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        RecordStore recordStore = mapServiceContext.getRecordStore(partitionId, this.name);
        this.keys = this.selectThisPartitionsKeys(this.keys);
        if (!this.replaceExistingValues) {
            this.removeExistingKeys(recordStore, this.keys);
        }
        recordStore.loadAllFromStore(this.keys, this.withUserSuppliedKeys);
    }

    @Override
    public void afterRun() throws Exception {
        if (this.replaceExistingValues) {
            this.clearLocalNearCache();
        }
        super.afterRun();
    }

    private void removeExistingKeys(RecordStore recordStore, Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Storage storage = recordStore.getStorage();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            if (!storage.containsKey(key)) continue;
            iterator.remove();
        }
    }

    private List<Data> selectThisPartitionsKeys(Collection<Data> keys) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        InternalPartitionService partitionService = mapServiceContext.getNodeEngine().getPartitionService();
        int partitionId = this.getPartitionId();
        ArrayList<Data> dataKeys = null;
        for (Data key : keys) {
            if (partitionId != partitionService.getPartitionId(key)) continue;
            if (dataKeys == null) {
                dataKeys = new ArrayList<Data>();
            }
            dataKeys.add(key);
        }
        if (dataKeys == null) {
            return Collections.emptyList();
        }
        return dataKeys;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int size = this.keys.size();
        out.writeInt(size);
        for (Data key : this.keys) {
            out.writeData(key);
        }
        out.writeBoolean(this.replaceExistingValues);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.withUserSuppliedKeys = this.isFlagSet(128);
        int size = in.readInt();
        if (size > 0) {
            this.keys = new ArrayList<Data>(size);
        }
        for (int i = 0; i < size; ++i) {
            Data data = in.readData();
            this.keys.add(data);
        }
        this.replaceExistingValues = in.readBoolean();
    }
}

