/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.executor.CompletableFutureTask;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientExecutionService.class);
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final ExecutorService userExecutor;
    private final ScheduledExecutorService internalExecutor;

    public ClientExecutionServiceImpl(String name, ThreadGroup threadGroup, ClassLoader classLoader, ClientProperties properties, int poolSize) {
        int executorPoolSize;
        int internalPoolSize = properties.getInteger(ClientProperty.INTERNAL_EXECUTOR_POOL_SIZE);
        if (internalPoolSize <= 0) {
            internalPoolSize = Integer.parseInt(ClientProperty.INTERNAL_EXECUTOR_POOL_SIZE.getDefaultValue());
        }
        if ((executorPoolSize = poolSize) <= 0) {
            executorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.internalExecutor = new ScheduledThreadPoolExecutor(internalPoolSize, new PoolExecutorThreadFactory(threadGroup, name + ".internal-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.userExecutor = new ThreadPoolExecutor(executorPoolSize, executorPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PoolExecutorThreadFactory(threadGroup, name + ".user-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
    }

    public void executeInternal(Runnable runnable) {
        this.internalExecutor.execute(runnable);
    }

    public <T> ICompletableFuture<T> submitInternal(Runnable runnable) {
        CompletableFutureTask<Object> futureTask = new CompletableFutureTask<Object>(runnable, null, this.internalExecutor);
        this.internalExecutor.submit(futureTask);
        return futureTask;
    }

    @Override
    public void execute(Runnable command) {
        this.userExecutor.execute(command);
    }

    @Override
    public ICompletableFuture<?> submit(Runnable task) {
        CompletableFutureTask<Object> futureTask = new CompletableFutureTask<Object>(task, null, this.getAsyncExecutor());
        this.userExecutor.submit(futureTask);
        return futureTask;
    }

    @Override
    public <T> ICompletableFuture<T> submit(Callable<T> task) {
        CompletableFutureTask<T> futureTask = new CompletableFutureTask<T>(task, this.getAsyncExecutor());
        this.userExecutor.submit(futureTask);
        return futureTask;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.internalExecutor.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.internalExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.internalExecutor.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ExecutorService getAsyncExecutor() {
        return this.userExecutor;
    }

    public void shutdown() {
        ClientExecutionServiceImpl.shutdownExecutor("user", this.userExecutor, LOGGER);
        ClientExecutionServiceImpl.shutdownExecutor("internal", this.internalExecutor, LOGGER);
    }

    public static void shutdownExecutor(String name, ExecutorService executor, ILogger logger) {
        executor.shutdown();
        try {
            boolean success = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                logger.warning(name + " executor awaitTermination could not completed in " + 30L + " seconds");
            }
        }
        catch (InterruptedException e) {
            logger.warning(name + " executor await termination is interrupted", e);
        }
    }

    public ExecutorService getInternalExecutor() {
        return this.internalExecutor;
    }
}

