/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.AbstractCacheAllPartitionsRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheClearRequest
extends AbstractCacheAllPartitionsRequest
implements RetryableRequest {
    private Set<Data> keys;
    private boolean isRemoveAll;
    private int completionId;

    public CacheClearRequest() {
    }

    public CacheClearRequest(String name, Set<Data> keys, boolean isRemoveAll, int completionId) {
        super(name);
        this.keys = keys;
        this.isRemoveAll = isRemoveAll;
        this.completionId = completionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("c", this.completionId);
        writer.writeBoolean("r", this.isRemoveAll);
        writer.writeBoolean("k", this.keys != null);
        if (this.keys != null && !this.keys.isEmpty()) {
            ObjectDataOutput output = writer.getRawDataOutput();
            output.writeInt(this.keys.size());
            for (Data key : this.keys) {
                output.writeData(key);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.completionId = reader.readInt("c");
        this.isRemoveAll = reader.readBoolean("r");
        boolean isKeysNotNull = reader.readBoolean("k");
        if (isKeysNotNull) {
            ObjectDataInput input = reader.getRawDataInput();
            int size = input.readInt();
            this.keys = new HashSet<Data>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    Data key = input.readData();
                    this.keys.add(key);
                }
            }
        }
    }

    @Override
    protected OperationFactory createOperationFactory() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        if (this.isRemoveAll) {
            return operationProvider.createRemoveAllOperationFactory(this.keys, this.completionId);
        }
        return operationProvider.createClearOperationFactory();
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        CacheService cacheService = (CacheService)this.getService();
        cacheService.sendInvalidationEvent(this.name, null, "<NA>");
        return map;
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "remove");
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null) {
            return null;
        }
        return new Object[]{this.keys};
    }

    @Override
    public String getMethodName() {
        if (this.isRemoveAll) {
            return "removeAll";
        }
        return "clear";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

