/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.impl.ClientMembershipListener;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class ClusterListenerSupport
implements ConnectionListener,
ConnectionHeartbeatListener,
ClientClusterService {
    private static final ILogger LOGGER = Logger.getLogger(ClusterListenerSupport.class);
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    protected final HazelcastClientInstanceImpl client;
    private final Collection<AddressProvider> addressProviders;
    private final ExecutorService clusterExecutor;
    private final boolean shuffleMemberList;
    private ClientConnectionManager connectionManager;
    private ClientMembershipListener clientMembershipListener;
    private volatile Address ownerConnectionAddress;
    private volatile ClientPrincipal principal;

    public ClusterListenerSupport(HazelcastClientInstanceImpl client, Collection<AddressProvider> addressProviders) {
        this.client = client;
        this.addressProviders = addressProviders;
        this.shuffleMemberList = client.getClientProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.clusterExecutor = this.createSingleThreadExecutorService(client);
    }

    private ExecutorService createSingleThreadExecutorService(HazelcastClientInstanceImpl client) {
        ThreadGroup threadGroup = client.getThreadGroup();
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(threadGroup, client.getName() + ".cluster-", classLoader);
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    protected void init() {
        this.connectionManager = this.client.getConnectionManager();
        this.clientMembershipListener = new ClientMembershipListener(this.client);
        this.connectionManager.addConnectionListener(this);
        this.connectionManager.addConnectionHeartbeatListener(this);
    }

    @Override
    public Address getOwnerConnectionAddress() {
        return this.ownerConnectionAddress;
    }

    public void shutdown() {
        this.clusterExecutor.shutdown();
        try {
            boolean success = this.clusterExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                LOGGER.warning("cluster executor awaitTermination could not completed in 30 seconds");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("cluster executor await termination is interrupted", e);
        }
    }

    private Collection<InetSocketAddress> getSocketAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        Collection<Member> memberList = this.getMemberList();
        for (Member member : memberList) {
            socketAddresses.add(member.getSocketAddress());
        }
        for (AddressProvider addressProvider : this.addressProviders) {
            socketAddresses.addAll(addressProvider.loadAddresses());
        }
        if (this.shuffleMemberList) {
            Collections.shuffle(socketAddresses);
        }
        return socketAddresses;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(ClientPrincipal principal) {
        this.principal = principal;
    }

    public void connectToCluster() throws Exception {
        this.ownerConnectionAddress = null;
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        int connAttemptLimit = networkConfig.getConnectionAttemptLimit();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        int connectionAttemptLimit = connAttemptLimit == 0 ? Integer.MAX_VALUE : connAttemptLimit;
        HashSet<InetSocketAddress> triedAddresses = new HashSet<InetSocketAddress>();
        for (int attempt = 0; attempt < connectionAttemptLimit; ++attempt) {
            if (!this.client.getLifecycleService().isRunning()) {
                if (!LOGGER.isFinestEnabled()) break;
                LOGGER.finest("Giving up on retrying to connect to cluster since client is shutdown");
                break;
            }
            long nextTry = Clock.currentTimeMillis() + (long)connectionAttemptPeriod;
            boolean isConnected = this.connect(triedAddresses);
            if (isConnected) {
                return;
            }
            long remainingTime = nextTry - Clock.currentTimeMillis();
            LOGGER.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config! The following addresses were tried:" + triedAddresses);
    }

    private boolean connect(Set<InetSocketAddress> triedAddresses) throws Exception {
        Collection<InetSocketAddress> socketAddresses = this.getSocketAddresses();
        for (InetSocketAddress inetSocketAddress : socketAddresses) {
            if (!this.client.getLifecycleService().isRunning()) {
                if (!LOGGER.isFinestEnabled()) break;
                LOGGER.finest("Giving up on retrying to connect to cluster since client is shutdown");
                break;
            }
            try {
                triedAddresses.add(inetSocketAddress);
                Address address = new Address(inetSocketAddress);
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Trying to connect to " + address);
                }
                Connection connection = this.connectionManager.getOrConnect(address, true);
                this.ownerConnectionAddress = connection.getEndPoint();
                this.clientMembershipListener.listenMembershipEvents(this.ownerConnectionAddress);
                this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
                return true;
            }
            catch (Exception e) {
                Level level = e instanceof AuthenticationException ? Level.WARNING : Level.FINEST;
                LOGGER.log(level, "Exception during initial connection to " + inetSocketAddress, e);
            }
        }
        return false;
    }

    private void fireConnectionEvent(final LifecycleEvent.LifecycleState state) {
        ClientExecutionService executionService = this.client.getClientExecutionService();
        executionService.execute(new Runnable(){

            @Override
            public void run() {
                LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)ClusterListenerSupport.this.client.getLifecycleService();
                lifecycleService.fireLifecycleEvent(state);
            }
        });
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        if (connection.getEndPoint().equals(this.ownerConnectionAddress) && this.client.getLifecycleService().isRunning()) {
            this.clusterExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClusterListenerSupport.this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
                        ClusterListenerSupport.this.connectToCluster();
                    }
                    catch (Exception e) {
                        LOGGER.warning("Could not re-connect to cluster shutting down the client", e);
                        ClusterListenerSupport.this.client.getLifecycleService().shutdown();
                    }
                }
            });
        }
    }

    @Override
    public void heartBeatStarted(Connection connection) {
    }

    @Override
    public void heartBeatStopped(Connection connection) {
        if (connection.getEndPoint().equals(this.ownerConnectionAddress)) {
            this.connectionManager.destroyConnection(connection, new TargetDisconnectedException("Heartbeat stopped"));
        }
    }
}

