/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetClearCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsCodec;
import com.hazelcast.client.impl.protocol.codec.SetGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetSizeCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClientSetProxy<E>
extends PartitionSpecificClientProxy
implements ISet<E> {
    public ClientSetProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    public int size() {
        ClientMessage request = SetSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetSizeCodec.ResponseParameters resultParameters = SetSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = SetIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetIsEmptyCodec.ResponseParameters resultParameters = SetIsEmptyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetContainsCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsCodec.ResponseParameters resultParameters = SetContainsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data element = this.toData(e);
        ClientMessage request = SetAddCodec.encodeRequest(this.name, element);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddCodec.ResponseParameters resultParameters = SetAddCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetRemoveCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        SetRemoveCodec.ResponseParameters resultParameters = SetRemoveCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetContainsAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsAllCodec.ResponseParameters resultParameters = SetContainsAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = SetAddAllCodec.encodeRequest(this.name, valueList);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddAllCodec.ResponseParameters resultParameters = SetAddAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRemoveAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRemoveAllCodec.ResponseParameters resultParameters = SetCompareAndRemoveAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRetainAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRetainAllCodec.ResponseParameters resultParameters = SetCompareAndRetainAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = SetClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ItemEventHandler eventHandler = new ItemEventHandler(listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return SetAddListenerCodec.encodeRequest(ClientSetProxy.this.name, includeValue, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return SetAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return SetRemoveListenerCodec.encodeRequest(ClientSetProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return SetRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = SetGetAllCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetGetAllCodec.ResponseParameters resultParameters = SetGetAllCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(resultCollection, serializationService);
    }

    public String toString() {
        return "ISet{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ItemListener<E> listener;

        public ItemEventHandler(ItemListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientSetProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientSetProxy.this.getContext().getClusterService();
            Member member = clusterService.getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientSetProxy.this.name, ItemEventType.getByType(eventType), dataItem, member, serializationService);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

