/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.DefaultClientExtension;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientNonSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ClientSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressProvider;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientNonSmartListenerService;
import com.hazelcast.client.spi.impl.listener.ClientSmartListenerService;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final ILogger LOGGER = Logger.getLogger(HazelcastClient.class);
    private static final short protocolVersion = 1;
    private final ClientProperties clientProperties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientTransactionManagerService transactionManager;
    private final NearCacheManager nearCacheManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final Credentials credentials;
    private final DiscoveryService discoveryService;
    private SerializationService serializationService;

    public HazelcastClientInstanceImpl(ClientConfig config, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        this.config = config;
        GroupConfig groupConfig = config.getGroupConfig();
        this.instanceName = config.getInstanceName() != null ? config.getInstanceName() : "hz.client_" + this.id + (groupConfig != null ? "_" + groupConfig.getName() : "");
        this.clientExtension = this.createClientInitializer(config.getClassLoader());
        this.clientExtension.beforeStart(this);
        this.credentials = this.initCredentials(config);
        this.threadGroup = new ThreadGroup(this.instanceName);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.clientProperties = new ClientProperties(config);
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.loadBalancer = this.initLoadBalancer(config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this, this.loadBalancer);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.discoveryService = this.initDiscoveryService(config);
        this.connectionManager = clientConnectionManagerFactory.createConnectionManager(config, this, this.discoveryService);
        Collection<AddressProvider> addressProviders = this.createAddressProviders(externalAddressProvider);
        this.clusterService = new ClientClusterServiceImpl(this, addressProviders);
        this.invocationService = this.initInvocationService();
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.nearCacheManager = this.clientExtension.createNearCacheManager();
        this.proxyManager.init(config);
    }

    private Collection<AddressProvider> createAddressProviders(AddressProvider externalAddressProvider) {
        ClientNetworkConfig networkConfig = this.getClientConfig().getNetworkConfig();
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        LinkedList<AddressProvider> addressProviders = new LinkedList<AddressProvider>();
        addressProviders.add(new DefaultAddressProvider(networkConfig));
        if (externalAddressProvider != null) {
            addressProviders.add(externalAddressProvider);
        }
        if (this.clientProperties.getBoolean(ClientProperty.DISCOVERY_SPI_ENABLED)) {
            this.discoveryService.start();
        }
        if (this.discoveryService != null) {
            addressProviders.add(new DiscoveryAddressProvider(this.discoveryService));
        }
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressProviders.add(new AwsAddressProvider(awsConfig));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        }
        return addressProviders;
    }

    private DiscoveryService initDiscoveryService(ClientConfig config) {
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig().getAsReadOnly();
        if (discoveryConfig == null || !discoveryConfig.isEnabled()) {
            return null;
        }
        DiscoveryServiceProvider factory = discoveryConfig.getDiscoveryServiceProvider();
        if (factory == null) {
            factory = new DefaultDiscoveryServiceProvider();
        }
        ILogger logger = Logger.getLogger(DiscoveryService.class);
        DiscoveryServiceSettings settings = new DiscoveryServiceSettings().setConfigClassLoader(config.getClassLoader()).setLogger(logger).setDiscoveryMode(DiscoveryMode.Client).setDiscoveryConfig(discoveryConfig);
        return factory.newDiscoveryService(settings);
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private Credentials initCredentials(ClientConfig config) {
        String credentialsClassname;
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance(config.getClassLoader(), credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return c;
    }

    private ClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new ClientSmartInvocationServiceImpl(this, this.loadBalancer);
        }
        return new ClientNonSmartInvocationServiceImpl(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator<ClientExtension> iter = ServiceLoader.iterator(ClientExtension.class, factoryId, classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultClientExtension();
    }

    private ClientListenerServiceImpl initListenerService() {
        int eventQueueCapacity = this.clientProperties.getInteger(ClientProperty.EVENT_QUEUE_CAPACITY);
        int eventThreadCount = this.clientProperties.getInteger(ClientProperty.EVENT_THREAD_COUNT);
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new ClientSmartListenerService(this, eventThreadCount, eventQueueCapacity);
        }
        return new ClientNonSmartListenerService(this, eventThreadCount, eventQueueCapacity);
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.threadGroup, this.config.getClassLoader(), this.config.getExecutorPoolSize());
    }

    public void start() {
        this.lifecycleService.setStarted();
        this.invocationService.start();
        this.connectionManager.start();
        try {
            this.clusterService.start();
        }
        catch (Exception e) {
            this.lifecycleService.shutdown();
            throw ExceptionUtil.rethrow(e);
        }
        this.listenerService.start();
        this.loadBalancer.init(this.getCluster(), this.config);
        this.partitionService.start();
        this.clientExtension.afterStart(this);
    }

    @Override
    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    @Override
    public String getName() {
        return this.instanceName;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    @Override
    public ILock getLock(String key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    @Override
    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    @Override
    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request).invoke();
            ClientMessage response = (ClientMessage)future.get();
            ClientGetDistributedObjectsCodec.ResponseParameters resultParameters = ClientGetDistributedObjectsCodec.decodeResponse(response);
            List<DistributedObjectInfo> infoCollection = resultParameters.response;
            for (DistributedObjectInfo distributedObjectInfo : infoCollection) {
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService);
    }

    @Override
    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public short getProtocolVersion() {
        return 1;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public void doShutdown() {
        this.proxyManager.destroy();
        this.clusterService.shutdown();
        this.executionService.shutdown();
        this.partitionService.stop();
        this.transactionManager.shutdown();
        this.connectionManager.shutdown();
        this.invocationService.shutdown();
        this.listenerService.shutdown();
        this.serializationService.destroy();
        this.nearCacheManager.destroyAllNearCaches();
        if (this.discoveryService != null) {
            this.discoveryService.destroy();
        }
    }
}

