/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;

public class ClusterAuthenticator
implements Authenticator {
    private final HazelcastClientInstanceImpl client;
    private final Credentials credentials;

    public ClusterAuthenticator(HazelcastClientInstanceImpl client, Credentials credentials) {
        this.client = client;
        this.credentials = credentials;
    }

    @Override
    public void authenticate(ClientConnection connection) throws AuthenticationException, IOException {
        ClientMessage response;
        ClientMessage clientMessage;
        SerializationService ss = this.client.getSerializationService();
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        ClientPrincipal principal = clusterService.getPrincipal();
        String uuid = principal.getUuid();
        String ownerUuid = principal.getOwnerUuid();
        if (this.credentials.getClass().equals(UsernamePasswordCredentials.class)) {
            UsernamePasswordCredentials cr = (UsernamePasswordCredentials)this.credentials;
            clientMessage = ClientAuthenticationCodec.encodeRequest(cr.getUsername(), cr.getPassword(), uuid, ownerUuid, false, "JVM", this.client.getSerializationService().getVersion());
        } else {
            Object data = ss.toData(this.credentials);
            clientMessage = ClientAuthenticationCustomCodec.encodeRequest(data, uuid, ownerUuid, false, "JVM", this.client.getSerializationService().getVersion());
        }
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientMessage, connection);
        ClientInvocationFuture future = clientInvocation.invokeUrgent();
        try {
            response = (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e, IOException.class);
        }
        ClientAuthenticationCodec.ResponseParameters result = ClientAuthenticationCodec.decodeResponse(response);
        AuthenticationStatus authenticationStatus = AuthenticationStatus.getById(result.status);
        switch (authenticationStatus) {
            case AUTHENTICATED: {
                connection.setRemoteEndpoint(result.address);
                return;
            }
            case CREDENTIALS_FAILED: {
                throw new AuthenticationException("Invalid credentials!");
            }
        }
        throw new AuthenticationException("Authentication status code not supported. status:" + (Object)((Object)authenticationStatus));
    }
}

