/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public final class PartitionIteratingOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private List<Integer> partitions;
    private OperationFactory operationFactory;
    private Map<Integer, Object> results;

    public PartitionIteratingOperation(List<Integer> partitions, OperationFactory operationFactory) {
        this.partitions = partitions != null ? partitions : Collections.emptyList();
        this.operationFactory = operationFactory;
    }

    public PartitionIteratingOperation() {
    }

    @Override
    public void run() throws Exception {
        this.results = new HashMap<Integer, Object>(this.partitions.size());
        try {
            Map<Integer, ResponseQueue> responses = this.executeOperations();
            this.getResults(responses);
        }
        catch (Exception e) {
            this.getLogger(this.getNodeEngine()).severe(e);
        }
    }

    private void getResults(Map<Integer, ResponseQueue> responses) throws InterruptedException {
        for (Map.Entry<Integer, ResponseQueue> responseQueueEntry : responses.entrySet()) {
            ResponseQueue queue = responseQueueEntry.getValue();
            Integer key = responseQueueEntry.getKey();
            Object result = queue.get();
            if (result instanceof NormalResponse) {
                this.results.put(key, ((NormalResponse)result).getValue());
                continue;
            }
            this.results.put(key, result);
        }
    }

    private Map<Integer, ResponseQueue> executeOperations() {
        NodeEngine nodeEngine = this.getNodeEngine();
        HashMap<Integer, ResponseQueue> responses = new HashMap<Integer, ResponseQueue>(this.partitions.size());
        for (int partitionId : this.partitions) {
            ResponseQueue responseQueue = new ResponseQueue();
            Operation op = this.operationFactory.createOperation();
            op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(this.getReplicaIndex()).setOperationResponseHandler(responseQueue).setServiceName(this.getServiceName()).setService(this.getService()).setCallerUuid(this.getCallerUuid());
            OperationAccessor.setCallerAddress(op, this.getCallerAddress());
            responses.put(partitionId, responseQueue);
            nodeEngine.getOperationService().executeOperation(op);
        }
        return responses;
    }

    @Override
    public void afterRun() throws Exception {
    }

    private ILogger getLogger(NodeEngine nodeEngine) {
        return nodeEngine.getLogger(PartitionIteratingOperation.class.getName());
    }

    @Override
    public Object getResponse() {
        return new PartitionResponse(this.results);
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int pCount = this.partitions.size();
        out.writeInt(pCount);
        for (Integer partition : this.partitions) {
            out.writeInt(partition);
        }
        out.writeObject(this.operationFactory);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int pCount = in.readInt();
        this.partitions = new ArrayList<Integer>(pCount);
        for (int i = 0; i < pCount; ++i) {
            this.partitions.add(in.readInt());
        }
        this.operationFactory = (OperationFactory)in.readObject();
    }

    public static final class PartitionResponse
    implements IdentifiedDataSerializable {
        private Map<Integer, Object> results;

        public PartitionResponse() {
        }

        public PartitionResponse(Map<Integer, Object> results) {
            this.results = results != null ? results : Collections.emptyMap();
        }

        public Map<? extends Integer, ?> asMap() {
            return this.results;
        }

        @Override
        public int getFactoryId() {
            return SpiDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            int len = this.results != null ? this.results.size() : 0;
            out.writeInt(len);
            if (len > 0) {
                for (Map.Entry<Integer, Object> entry : this.results.entrySet()) {
                    out.writeInt(entry.getKey());
                    out.writeObject(entry.getValue());
                }
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int len = in.readInt();
            if (len > 0) {
                this.results = new HashMap<Integer, Object>(len);
                for (int i = 0; i < len; ++i) {
                    int pid = in.readInt();
                    Object value = in.readObject();
                    this.results.put(pid, value);
                }
            } else {
                this.results = Collections.emptyMap();
            }
        }
    }

    private static class ResponseQueue
    implements OperationResponseHandler {
        final BlockingQueue b = ResponseQueueFactory.newResponseQueue();

        private ResponseQueue() {
        }

        public void sendResponse(Operation op, Object obj) {
            if (!this.b.offer(obj)) {
                throw new HazelcastException("Response could not be queued for transportation");
            }
        }

        public Object get() throws InterruptedException {
            return this.b.take();
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

