/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.record.AbstractRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class StorageImpl<R extends Record>
implements Storage<Data, R> {
    private final RecordFactory<R> recordFactory;
    private final ConcurrentMap<Data, R> records = new ConcurrentHashMap<Data, R>(1000, 0.75f, 1);
    private SizeEstimator sizeEstimator;

    StorageImpl(RecordFactory<R> recordFactory, InMemoryFormat inMemoryFormat) {
        this.recordFactory = recordFactory;
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator(inMemoryFormat);
    }

    @Override
    public void clear() {
        this.records.clear();
        this.sizeEstimator.reset();
    }

    @Override
    public Collection<R> values() {
        return this.records.values();
    }

    @Override
    public void put(Data key, R record) {
        ((AbstractRecord)record).setKey(key);
        Record previousRecord = (Record)this.records.put(key, record);
        if (previousRecord == null) {
            this.updateSizeEstimator(this.calculateHeapCost(key));
        }
        this.updateSizeEstimator(-this.calculateHeapCost(previousRecord));
        this.updateSizeEstimator(this.calculateHeapCost(record));
    }

    @Override
    public void updateRecordValue(Data key, R record, Object value) {
        this.updateSizeEstimator(-this.calculateHeapCost(record));
        this.recordFactory.setValue((Record<R>)record, value);
        this.updateSizeEstimator(this.calculateHeapCost(record));
    }

    @Override
    public R get(Data key) {
        return (R)((Record)this.records.get(key));
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public SizeEstimator getSizeEstimator() {
        return this.sizeEstimator;
    }

    @Override
    public boolean containsKey(Data key) {
        return this.records.containsKey(key);
    }

    @Override
    public void removeRecord(R record) {
        if (record == null) {
            return;
        }
        Data key = record.getKey();
        this.records.remove(key);
        this.updateSizeEstimator(-this.calculateHeapCost(record));
        this.updateSizeEstimator(-this.calculateHeapCost(key));
    }

    protected void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    protected long calculateHeapCost(Object obj) {
        return this.sizeEstimator.calculateSize(obj);
    }

    @Override
    public void setSizeEstimator(SizeEstimator sizeEstimator) {
        this.sizeEstimator = sizeEstimator;
    }

    @Override
    public void dispose() {
    }
}

