/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.Data;

class BinaryMapSizeEstimator
implements SizeEstimator {
    private volatile long size;

    BinaryMapSizeEstimator() {
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void add(long size) {
        this.size += size;
    }

    @Override
    public void reset() {
        this.size = 0L;
    }

    public long calculateSize(Object object) {
        if (object instanceof Data) {
            long keyCost = ((Data)object).getHeapCost();
            return keyCost += 4L;
        }
        if (object instanceof Record) {
            long recordCost = ((Record)object).getCost();
            recordCost += 4L;
            recordCost += 4L;
            return recordCost += 4L;
        }
        return 0L;
    }
}

