/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class QueryResult
implements DataSerializable {
    private final Collection<QueryResultEntry> result = new LinkedHashSet<QueryResultEntry>();
    private Collection<Integer> partitionIds;
    private transient long resultLimit;
    private transient long resultSize;

    public QueryResult() {
        this(Long.MAX_VALUE);
    }

    public QueryResult(long resultLimit) {
        this.resultLimit = resultLimit;
    }

    public void addAll(Collection<QueryableEntry> queryableEntries) {
        for (QueryableEntry entry : queryableEntries) {
            if (++this.resultSize > this.resultLimit) {
                throw new QueryResultSizeExceededException();
            }
            QueryResultEntryImpl queryEntry = new QueryResultEntryImpl(entry.getKeyData(), entry.getIndexKey(), entry.getValueData());
            this.result.add(queryEntry);
        }
    }

    public void setPartitionIds(Collection<Integer> partitionIds) {
        this.partitionIds = partitionIds;
    }

    public Collection<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public Collection<QueryResultEntry> getResult() {
        return this.result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int partitionSize = this.partitionIds == null ? 0 : this.partitionIds.size();
        out.writeInt(partitionSize);
        if (partitionSize > 0) {
            for (Integer partitionId : this.partitionIds) {
                out.writeInt(partitionId);
            }
        }
        int resultSize = this.result.size();
        out.writeInt(resultSize);
        if (resultSize > 0) {
            Iterator<QueryResultEntry> iterator = this.result.iterator();
            for (int i = 0; i < resultSize; ++i) {
                QueryResultEntryImpl queryableEntry = (QueryResultEntryImpl)iterator.next();
                queryableEntry.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int resultSize;
        int partitionSize = in.readInt();
        if (partitionSize > 0) {
            this.partitionIds = new ArrayList<Integer>(partitionSize);
            for (int i = 0; i < partitionSize; ++i) {
                this.partitionIds.add(in.readInt());
            }
        }
        if ((resultSize = in.readInt()) > 0) {
            for (int i = 0; i < resultSize; ++i) {
                QueryResultEntryImpl resultEntry = new QueryResultEntryImpl();
                resultEntry.readData(in);
                this.result.add(resultEntry);
            }
        }
    }
}

