/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.topic.impl.DataAwareMessage;
import com.hazelcast.topic.impl.TopicEvent;
import com.hazelcast.topic.impl.TopicProxy;
import com.hazelcast.topic.impl.TotalOrderedTopicProxy;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.MapUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TopicService
implements ManagedService,
RemoteService,
EventPublishingService,
StatisticsAwareService {
    public static final String SERVICE_NAME = "hz:impl:topicService";
    public static final int ORDERING_LOCKS_LENGTH = 1000;
    private final ConcurrentMap<String, LocalTopicStatsImpl> statsMap = new ConcurrentHashMap<String, LocalTopicStatsImpl>();
    private final Lock[] orderingLocks = new Lock[1000];
    private NodeEngine nodeEngine;
    private final ConstructorFunction<String, LocalTopicStatsImpl> localTopicStatsConstructorFunction = new ConstructorFunction<String, LocalTopicStatsImpl>(){

        @Override
        public LocalTopicStatsImpl createNew(String mapName) {
            return new LocalTopicStatsImpl();
        }
    };
    private EventService eventService;
    private ILogger logger;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        for (int i = 0; i < this.orderingLocks.length; ++i) {
            this.orderingLocks[i] = new ReentrantLock();
        }
        this.eventService = nodeEngine.getEventService();
        this.logger = nodeEngine.getLogger(TopicService.class);
    }

    public ConcurrentMap<String, LocalTopicStatsImpl> getStatsMap() {
        return this.statsMap;
    }

    @Override
    public void reset() {
        this.statsMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public Lock getOrderLock(String key) {
        int index = this.getOrderLockIndex(key);
        return this.orderingLocks[index];
    }

    private int getOrderLockIndex(String key) {
        int hash = key.hashCode();
        if (hash == Integer.MIN_VALUE) {
            return 0;
        }
        return Math.abs(hash) % this.orderingLocks.length;
    }

    @Override
    public ITopic createDistributedObject(String name) {
        TopicConfig topicConfig = this.nodeEngine.getConfig().findTopicConfig(name);
        if (topicConfig.isGlobalOrderingEnabled()) {
            return new TotalOrderedTopicProxy(name, this.nodeEngine, this);
        }
        return new TopicProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectId) {
        this.statsMap.remove(objectId);
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, objectId);
    }

    public void dispatchEvent(Object event, Object listener) {
        TopicEvent topicEvent = (TopicEvent)event;
        ClusterService clusterService = this.nodeEngine.getClusterService();
        MemberImpl member = clusterService.getMember(topicEvent.publisherAddress);
        if (member == null) {
            member = new MemberImpl(topicEvent.publisherAddress, false);
        }
        DataAwareMessage message = new DataAwareMessage(topicEvent.name, topicEvent.data, topicEvent.publishTime, member, this.nodeEngine.getSerializationService());
        this.incrementReceivedMessages(topicEvent.name);
        MessageListener messageListener = (MessageListener)listener;
        messageListener.onMessage(message);
    }

    public LocalTopicStatsImpl getLocalTopicStats(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.statsMap, name, this.statsMap, this.localTopicStatsConstructorFunction);
    }

    public void incrementPublishes(String topicName) {
        this.getLocalTopicStats(topicName).incrementPublishes();
    }

    public void incrementReceivedMessages(String topicName) {
        this.getLocalTopicStats(topicName).incrementReceives();
    }

    public void publishEvent(String name, TopicEvent event) {
        Collection<EventRegistration> registrations = this.eventService.getRegistrations(SERVICE_NAME, name);
        this.eventService.publishEvent(SERVICE_NAME, registrations, (Object)event, name.hashCode());
    }

    public String addMessageListener(String name, MessageListener listener) {
        EventRegistration eventRegistration = this.eventService.registerListener(SERVICE_NAME, name, listener);
        return eventRegistration.getId();
    }

    public boolean removeMessageListener(String name, String registrationId) {
        return this.eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public Map<String, LocalTopicStats> getStats() {
        Map<String, LocalTopicStats> topicStats = MapUtil.createHashMap(this.statsMap.size());
        for (Map.Entry queueStat : this.statsMap.entrySet()) {
            topicStats.put((String)queueStat.getKey(), (LocalTopicStats)queueStat.getValue());
        }
        return topicStats;
    }
}

