/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.impl.EventPacket;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceSegment;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.util.executor.StripedRunnable;

public class EventPacketProcessor
implements StripedRunnable {
    private final EventServiceImpl eventService;
    private final int orderKey;
    private final EventPacket eventPacket;

    public EventPacketProcessor(EventServiceImpl eventService, EventPacket packet, int orderKey) {
        this.eventService = eventService;
        this.eventPacket = packet;
        this.orderKey = orderKey;
    }

    @Override
    public void run() {
        this.process(this.eventPacket);
    }

    void process(EventPacket eventPacket) {
        Object eventObject = this.getEventObject(eventPacket);
        String serviceName = eventPacket.getServiceName();
        EventPublishingService service = (EventPublishingService)this.eventService.nodeEngine.getService(serviceName);
        Registration registration = this.getRegistration(eventPacket, serviceName);
        if (registration == null) {
            return;
        }
        service.dispatchEvent(eventObject, registration.getListener());
    }

    private Registration getRegistration(EventPacket eventPacket, String serviceName) {
        EventServiceSegment segment = this.eventService.getSegment(serviceName, false);
        if (segment == null) {
            if (this.eventService.nodeEngine.isActive()) {
                this.eventService.logger.warning("No service registration found for " + serviceName);
            }
            return null;
        }
        String id = eventPacket.getEventId();
        Registration registration = (Registration)segment.getRegistrationIdMap().get(id);
        if (registration == null) {
            if (this.eventService.nodeEngine.isActive() && this.eventService.logger.isFinestEnabled()) {
                this.eventService.logger.finest("No registration found for " + serviceName + " / " + id);
            }
            return null;
        }
        if (!this.eventService.isLocal(registration)) {
            this.eventService.logger.severe("Invalid target for  " + registration);
            return null;
        }
        if (registration.getListener() == null) {
            this.eventService.logger.warning("Something seems wrong! Subscriber is local but listener instance is null! -> " + registration);
            return null;
        }
        return registration;
    }

    private Object getEventObject(EventPacket eventPacket) {
        Object eventObject = eventPacket.getEvent();
        if (eventObject instanceof Data) {
            eventObject = this.eventService.nodeEngine.toObject(eventObject);
        }
        return eventObject;
    }

    @Override
    public int getKey() {
        return this.orderKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EventPacketProcessor{");
        sb.append("eventPacket=").append(this.eventPacket);
        sb.append('}');
        return sb.toString();
    }
}

