/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.Member;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.management.TimedMemberStateFactoryHelper;
import com.hazelcast.internal.management.dto.ClientEndPointDTO;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.monitor.LocalOperationStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.monitor.impl.LocalMemoryStatsImpl;
import com.hazelcast.monitor.impl.LocalOperationStatsImpl;
import com.hazelcast.monitor.impl.MemberPartitionStateImpl;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.topic.impl.TopicService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TimedMemberStateFactory {
    private static final int INITIAL_PARTITION_SAFETY_CHECK_DELAY = 15;
    private static final int PARTITION_SAFETY_CHECK_PERIOD = 60;
    private final HazelcastInstanceImpl instance;
    private final int maxVisibleInstanceCount;
    private final boolean cacheServiceEnabled;
    private volatile boolean memberStateSafe = true;

    public TimedMemberStateFactory(HazelcastInstanceImpl instance) {
        this.instance = instance;
        Node node = instance.node;
        this.maxVisibleInstanceCount = node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.cacheServiceEnabled = this.isCacheServiceEnabled();
    }

    public void init() {
        this.instance.node.nodeEngine.getExecutionService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimedMemberStateFactory.this.memberStateSafe = TimedMemberStateFactory.this.instance.getPartitionService().isLocalMemberSafe();
            }
        }, 15L, 60L, TimeUnit.SECONDS);
    }

    public TimedMemberState createTimedMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        Collection<StatisticsAwareService> services = this.instance.node.nodeEngine.getServices(StatisticsAwareService.class);
        TimedMemberState timedMemberState = new TimedMemberState();
        this.createMemberState(timedMemberState, memberState, services);
        timedMemberState.setMaster(this.instance.node.isMaster());
        timedMemberState.setMemberList(new ArrayList<String>());
        if (timedMemberState.getMaster().booleanValue()) {
            Set<Member> memberSet = this.instance.getCluster().getMembers();
            for (Member member : memberSet) {
                MemberImpl memberImpl = (MemberImpl)member;
                Address address = memberImpl.getAddress();
                timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
            }
        }
        timedMemberState.setMemberState(memberState);
        GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
        timedMemberState.setClusterName(groupConfig.getName());
        return timedMemberState;
    }

    protected LocalMemoryStats getMemoryStats() {
        return new LocalMemoryStatsImpl(this.instance.getMemoryStats());
    }

    protected LocalOperationStats getOperationStats() {
        return new LocalOperationStatsImpl(this.instance.node);
    }

    private void createMemberState(TimedMemberState timedMemberState, MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        Node node = this.instance.node;
        HashSet<ClientEndPointDTO> serializableClientEndPoints = new HashSet<ClientEndPointDTO>();
        for (Client client : this.instance.node.clientEngine.getClients()) {
            serializableClientEndPoints.add(new ClientEndPointDTO(client));
        }
        memberState.setClients(serializableClientEndPoints);
        Address thisAddress = node.getThisAddress();
        memberState.setAddress(thisAddress.getHost() + ":" + thisAddress.getPort());
        TimedMemberStateFactoryHelper.registerJMXBeans(this.instance, memberState);
        MemberPartitionStateImpl memberPartitionState = (MemberPartitionStateImpl)memberState.getMemberPartitionState();
        InternalPartitionService partitionService = node.getPartitionService();
        InternalPartition[] partitions = partitionService.getPartitions();
        List<Integer> partitionList = memberPartitionState.getPartitions();
        for (InternalPartition partition : partitions) {
            if (!partition.isLocal()) continue;
            partitionList.add(partition.getPartitionId());
        }
        memberPartitionState.setMigrationQueueSize(partitionService.getMigrationQueueSize());
        memberPartitionState.setMemberStateSafe(this.memberStateSafe);
        memberState.setLocalMemoryStats(this.getMemoryStats());
        memberState.setOperationStats(this.getOperationStats());
        TimedMemberStateFactoryHelper.createRuntimeProps(memberState);
        this.createMemState(timedMemberState, memberState, services);
    }

    private void createMemState(TimedMemberState timedMemberState, MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        int count = 0;
        Config config = this.instance.getConfig();
        HashSet<String> longInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        for (StatisticsAwareService service : services) {
            if (count >= this.maxVisibleInstanceCount) continue;
            if (service instanceof MapService) {
                count = this.handleMap(memberState, count, config, ((MapService)service).getStats(), longInstanceNames);
                continue;
            }
            if (service instanceof MultiMapService) {
                count = this.handleMultimap(memberState, count, config, ((MultiMapService)service).getStats(), longInstanceNames);
                continue;
            }
            if (service instanceof QueueService) {
                count = this.handleQueue(memberState, count, config, ((QueueService)service).getStats(), longInstanceNames);
                continue;
            }
            if (service instanceof TopicService) {
                count = this.handleTopic(memberState, count, config, ((TopicService)service).getStats(), longInstanceNames);
                continue;
            }
            if (!(service instanceof DistributedExecutorService)) continue;
            count = this.handleExecutorService(memberState, count, config, ((DistributedExecutorService)service).getStats(), longInstanceNames);
        }
        if (this.cacheServiceEnabled) {
            ICacheService cacheService = this.getCacheService();
            for (CacheConfig cacheConfig : cacheService.getCacheConfigs()) {
                if (!cacheConfig.isStatisticsEnabled() || count >= this.maxVisibleInstanceCount) continue;
                CacheStatistics statistics = cacheService.getStatistics(cacheConfig.getNameWithPrefix());
                count = this.handleCache(memberState, count, cacheConfig, statistics, longInstanceNames);
            }
        }
        timedMemberState.setInstanceNames(longInstanceNames);
    }

    private int handleExecutorService(MemberStateImpl memberState, int count, Config config, Map<String, LocalExecutorStats> executorServices, Set<String> longInstanceNames) {
        for (Map.Entry<String, LocalExecutorStats> entry : executorServices.entrySet()) {
            String name = entry.getKey();
            if (count >= this.maxVisibleInstanceCount) break;
            if (!config.findExecutorConfig(name).isStatisticsEnabled()) continue;
            LocalExecutorStats stats = entry.getValue();
            memberState.putLocalExecutorStats(name, stats);
            longInstanceNames.add("e:" + name);
            ++count;
        }
        return count;
    }

    private int handleMultimap(MemberStateImpl memberState, int count, Config config, Map<String, LocalMultiMapStats> multiMaps, Set<String> longInstanceNames) {
        for (Map.Entry<String, LocalMultiMapStats> entry : multiMaps.entrySet()) {
            String name = entry.getKey();
            if (count >= this.maxVisibleInstanceCount) break;
            if (!config.findMultiMapConfig(name).isStatisticsEnabled()) continue;
            LocalMultiMapStats stats = entry.getValue();
            memberState.putLocalMultiMapStats(name, stats);
            longInstanceNames.add("m:" + name);
            ++count;
        }
        return count;
    }

    private int handleTopic(MemberStateImpl memberState, int count, Config config, Map<String, LocalTopicStats> topics, Set<String> longInstanceNames) {
        for (Map.Entry<String, LocalTopicStats> entry : topics.entrySet()) {
            String name = entry.getKey();
            if (count >= this.maxVisibleInstanceCount) break;
            if (!config.findTopicConfig(name).isStatisticsEnabled()) continue;
            LocalTopicStats stats = entry.getValue();
            memberState.putLocalTopicStats(name, stats);
            longInstanceNames.add("t:" + name);
            ++count;
        }
        return count;
    }

    private int handleQueue(MemberStateImpl memberState, int count, Config config, Map<String, LocalQueueStats> queues, Set<String> longInstanceNames) {
        for (Map.Entry<String, LocalQueueStats> entry : queues.entrySet()) {
            String name = entry.getKey();
            if (count >= this.maxVisibleInstanceCount) break;
            if (!config.findQueueConfig(name).isStatisticsEnabled()) continue;
            LocalQueueStats stats = entry.getValue();
            memberState.putLocalQueueStats(name, stats);
            longInstanceNames.add("q:" + name);
            ++count;
        }
        return count;
    }

    private int handleMap(MemberStateImpl memberState, int count, Config config, Map<String, LocalMapStats> maps, Set<String> longInstanceNames) {
        for (Map.Entry<String, LocalMapStats> entry : maps.entrySet()) {
            String name = entry.getKey();
            if (count >= this.maxVisibleInstanceCount) break;
            if (!config.findMapConfig(name).isStatisticsEnabled()) continue;
            LocalMapStats stats = entry.getValue();
            memberState.putLocalMapStats(name, stats);
            longInstanceNames.add("c:" + name);
            ++count;
        }
        return count;
    }

    private int handleCache(MemberStateImpl memberState, int count, CacheConfig config, CacheStatistics cacheStatistics, Set<String> longInstanceNames) {
        memberState.putLocalCacheStats(config.getNameWithPrefix(), new LocalCacheStatsImpl(cacheStatistics));
        longInstanceNames.add("j:" + config.getNameWithPrefix());
        return ++count;
    }

    private ICacheService getCacheService() {
        CacheDistributedObject setupRef = (CacheDistributedObject)this.instance.getDistributedObject("hz:impl:cacheService", "setupRef");
        return (ICacheService)setupRef.getService();
    }

    private boolean isCacheServiceEnabled() {
        NodeEngineImpl nodeEngine = this.instance.node.nodeEngine;
        Collection<ServiceInfo> serviceInfos = nodeEngine.getServiceInfos(CacheService.class);
        return !serviceInfos.isEmpty();
    }
}

