/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CachePartitionSegment {
    private final AbstractCacheService cacheService;
    private final int partitionId;
    private final ConstructorFunction<String, ICacheRecordStore> cacheConstructorFunction;
    private final ConcurrentMap<String, ICacheRecordStore> caches = new ConcurrentHashMap<String, ICacheRecordStore>();
    private final Object mutex = new Object();

    CachePartitionSegment(final AbstractCacheService cacheService, final int partitionId) {
        this.cacheConstructorFunction = new ConstructorFunction<String, ICacheRecordStore>(){

            @Override
            public ICacheRecordStore createNew(String arg) {
                return cacheService.createNewRecordStore(arg, partitionId);
            }
        };
        this.cacheService = cacheService;
        this.partitionId = partitionId;
    }

    public Iterator<ICacheRecordStore> cacheIterator() {
        return this.caches.values().iterator();
    }

    public Collection<CacheConfig> getCacheConfigs() {
        return this.cacheService.getCacheConfigs();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ICacheRecordStore getOrCreateCache(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.caches, name, this.mutex, this.cacheConstructorFunction);
    }

    public ICacheRecordStore getCache(String name) {
        return (ICacheRecordStore)this.caches.get(name);
    }

    public void deleteCache(String name) {
        ICacheRecordStore cache = (ICacheRecordStore)this.caches.remove(name);
        if (cache != null) {
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore cache : this.caches.values()) {
                cache.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore cache : this.caches.values()) {
                cache.destroy();
            }
        }
        this.caches.clear();
    }

    public void destroy() {
        this.clear();
    }

    public boolean hasAnyCache() {
        return !this.caches.isEmpty();
    }

    public boolean hasCache(String name) {
        return this.caches.containsKey(name);
    }
}

