/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientInvocation
implements Runnable {
    private static final long RETRY_WAIT_TIME_IN_SECONDS = 1L;
    private static final int UNASSIGNED_PARTITION = -1;
    private static final ILogger LOGGER = Logger.getLogger(ClientInvocation.class);
    private final LifecycleService lifecycleService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientRequest request;
    private final EventHandler handler;
    private final ClientInvocationFuture clientInvocationFuture;
    private final int heartBeatInterval;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private long retryTimeoutPointInMillis;
    private volatile ClientConnection sendConnection;

    private ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, int partitionId, Address address, Connection connection) {
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.listenerService = (ClientListenerServiceImpl)client.getListenerService();
        this.handler = handler;
        this.request = request;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        ClientProperties clientProperties = client.getClientProperties();
        int waitTime = clientProperties.getInvocationTimeoutSeconds().getInteger();
        long retryTimeoutInSeconds = waitTime > 0 ? (long)waitTime : (long)Integer.parseInt("120");
        this.clientInvocationFuture = new ClientInvocationFuture(this, client, request, handler);
        this.retryTimeoutPointInMillis = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(retryTimeoutInSeconds);
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("5000");
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request) {
        this(client, handler, request, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, int partitionId) {
        this(client, handler, request, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, Address address) {
        this(client, handler, request, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, Connection connection) {
        this(client, handler, request, -1, null, connection);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request) {
        this(client, null, request);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, int partitionId) {
        this(client, null, request, partitionId);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, Address address) {
        this(client, null, request, address);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, Connection connection) {
        this(client, null, request, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public EventHandler getHandler() {
        return this.handler;
    }

    public ClientInvocationFuture invoke() {
        if (this.request == null) {
            throw new IllegalStateException("Request can not be null");
        }
        try {
            this.invokeOnSelection();
        }
        catch (Exception e) {
            this.notify(e);
        }
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() throws IOException {
        if (this.isBindToSingleConnection()) {
            this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
        } else if (this.partitionId != -1) {
            this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
        } else if (this.address != null) {
            this.invocationService.invokeOnTarget(this, this.address);
        } else {
            this.invocationService.invokeOnRandomTarget(this);
        }
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Throwable e) {
            if (this.handler != null) {
                this.listenerService.registerFailedListener(this);
            }
            this.clientInvocationFuture.setResponse(e);
        }
    }

    public void notify(Object response) {
        if (response == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        if (!(response instanceof Exception)) {
            this.clientInvocationFuture.setResponse(response);
            return;
        }
        Exception exception = (Exception)response;
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.setResponse(new HazelcastClientNotActiveException(exception.getMessage()));
            return;
        }
        this.notifyException(exception);
    }

    private void notifyException(Exception exception) {
        if ((exception instanceof IOException || exception instanceof HazelcastInstanceNotActiveException || exception instanceof AuthenticationException) && this.handleRetry()) {
            return;
        }
        if (exception instanceof RetryableHazelcastException && (this.request instanceof RetryableRequest || this.invocationService.isRedoOperation()) && this.handleRetry()) {
            return;
        }
        this.clientInvocationFuture.setResponse(exception);
    }

    private boolean handleRetry() {
        if (this.isBindToSingleConnection()) {
            return false;
        }
        if (this.handler == null && System.currentTimeMillis() > this.retryTimeoutPointInMillis) {
            return false;
        }
        if (this.handler != null) {
            this.handler.beforeListenerRegister();
        }
        try {
            this.rescheduleInvocation();
        }
        catch (RejectedExecutionException e) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Retry could not be scheduled ", e);
            }
            this.clientInvocationFuture.setResponse(e);
        }
        return true;
    }

    private void rescheduleInvocation() {
        this.executionService.schedule(new Runnable(){

            @Override
            public void run() {
                ICompletableFuture future = ((ClientExecutionServiceImpl)ClientInvocation.this.executionService).submitInternal(ClientInvocation.this);
                future.andThen(new ExecutionCallback(){

                    public void onResponse(Object response) {
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        if (LOGGER.isFinestEnabled()) {
                            LOGGER.finest("Failure during retry ", t);
                        }
                        ClientInvocation.this.clientInvocationFuture.setResponse(t);
                    }
                });
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    boolean isConnectionHealthy(long elapsed) {
        if (elapsed >= (long)this.heartBeatInterval) {
            if (this.sendConnection != null) {
                return this.sendConnection.isHeartBeating();
            }
            return true;
        }
        return true;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }
}

