/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientMembershipListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import java.security.Permission;
import java.util.Collection;

public class RegisterMembershipListenerMessageTask
extends AbstractCallableMessageTask<ClientMembershipListenerCodec.RequestParameters> {
    public RegisterMembershipListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        String serviceName = "hz:core:clusterService";
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService(serviceName);
        ClientEndpoint endpoint = this.getEndpoint();
        String registrationId = service.addMembershipListener(new MembershipListenerImpl(endpoint));
        endpoint.addListenerDestroyAction(serviceName, serviceName, registrationId);
        return registrationId;
    }

    @Override
    protected ClientMembershipListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientMembershipListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientMembershipListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class MembershipListenerImpl
    implements InitialMembershipListener {
        private final ClientEndpoint endpoint;

        public MembershipListenerImpl(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void init(InitialMembershipEvent membershipEvent) {
            ClusterService service = (ClusterService)RegisterMembershipListenerMessageTask.this.getService("hz:core:clusterService");
            Collection<Member> memberList = service.getMemberList();
            ClientMessage eventMessage = ClientMembershipListenerCodec.encodeMemberListEvent(memberList);
            RegisterMembershipListenerMessageTask.this.sendClientMessage(this.endpoint.getUuid(), eventMessage);
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientMessage eventMessage = ClientMembershipListenerCodec.encodeMemberEvent(member, 1);
            RegisterMembershipListenerMessageTask.this.sendClientMessage(this.endpoint.getUuid(), eventMessage);
        }

        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientMessage eventMessage = ClientMembershipListenerCodec.encodeMemberEvent(member, 2);
            RegisterMembershipListenerMessageTask.this.sendClientMessage(this.endpoint.getUuid(), eventMessage);
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)memberAttributeEvent.getMember();
            String uuid = member.getUuid();
            MemberAttributeOperationType op = memberAttributeEvent.getOperationType();
            String key = memberAttributeEvent.getKey();
            Object value = memberAttributeEvent.getValue();
            MemberAttributeChange memberAttributeChange = new MemberAttributeChange(uuid, op, key, value);
            ClientMessage eventMessage = ClientMembershipListenerCodec.encodeMemberAttributeChangeEvent(memberAttributeChange);
            RegisterMembershipListenerMessageTask.this.sendClientMessage(this.endpoint.getUuid(), eventMessage);
        }
    }
}

