/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.ClientResponse;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class ClientListenerServiceImpl
implements ClientListenerService {
    private final ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private final HazelcastClientInstanceImpl client;
    private final ClientInvocationService invocationService;
    private final SerializationService serializationService;
    private final ConcurrentMap<String, Integer> registrationMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, String> registrationAliasMap = new ConcurrentHashMap<String, String>();
    private final StripedExecutor eventExecutor;
    private final Set<ClientInvocation> failedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public ClientListenerServiceImpl(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.invocationService = client.getInvocationService();
        this.serializationService = client.getSerializationService();
        this.eventExecutor = new StripedExecutor(this.logger, client.getName() + ".event", client.getThreadGroup(), eventThreadCount, eventQueueCapacity);
    }

    public StripedExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    @Override
    public String startListening(ClientRequest request, Object key, EventHandler handler) {
        try {
            ClientInvocationFuture future;
            handler.beforeListenerRegister();
            if (key == null) {
                future = new ClientInvocation(this.client, handler, request).invoke();
            } else {
                int partitionId = this.client.getClientPartitionService().getPartitionId(key);
                future = new ClientInvocation(this.client, handler, request, partitionId).invoke();
            }
            String registrationId = (String)this.serializationService.toObject(future.get());
            this.registerListener(registrationId, request.getCallId());
            return registrationId;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean stopListening(BaseClientRemoveListenerRequest request, String registrationId) {
        try {
            String realRegistrationId = this.deRegisterListener(registrationId);
            if (realRegistrationId == null) {
                return false;
            }
            request.setRegistrationId(realRegistrationId);
            ClientInvocationFuture future = new ClientInvocation(this.client, request).invoke();
            future.get();
            return true;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void registerFailedListener(ClientInvocation future) {
        this.failedListeners.add(future);
    }

    public void triggerFailedListeners() {
        Iterator<ClientInvocation> iterator = this.failedListeners.iterator();
        while (iterator.hasNext()) {
            ClientInvocation failedListener = iterator.next();
            iterator.remove();
            failedListener.notify(new TargetDisconnectedException());
        }
    }

    @Override
    public void registerListener(String uuid, Integer callId) {
        this.registrationAliasMap.put(uuid, uuid);
        this.registrationMap.put(uuid, callId);
    }

    public void reRegisterListener(String uuid, String alias, Integer callId) {
        String oldAlias = this.registrationAliasMap.put(uuid, alias);
        if (oldAlias != null) {
            this.registrationMap.remove(oldAlias);
            this.registrationMap.put(alias, callId);
        }
    }

    @Override
    public String deRegisterListener(String alias) {
        String uuid = (String)this.registrationAliasMap.remove(alias);
        if (uuid != null) {
            Integer callId = (Integer)this.registrationMap.remove(alias);
            this.invocationService.removeEventHandler(callId);
        }
        return uuid;
    }

    public void handleEventPacket(Packet packet) {
        try {
            this.eventExecutor.execute(new ClientEventProcessor(packet));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event packet could not be handled ", e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
    }

    private final class ClientEventProcessor
    implements StripedRunnable {
        final Packet packet;

        private ClientEventProcessor(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            ClientConnection conn = (ClientConnection)this.packet.getConn();
            ClientResponse clientResponse = (ClientResponse)ClientListenerServiceImpl.this.serializationService.toObject(this.packet.getData());
            int callId = clientResponse.getCallId();
            Data response = clientResponse.getResponse();
            this.handleEvent(response, callId, conn);
        }

        private void handleEvent(Data event, int callId, ClientConnection conn) {
            Object eventObject = ClientListenerServiceImpl.this.serializationService.toObject(event);
            EventHandler eventHandler = ClientListenerServiceImpl.this.invocationService.getEventHandler(callId);
            if (eventHandler == null) {
                ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + callId + ", event: " + eventObject + ", conn: " + conn);
                return;
            }
            eventHandler.handle(eventObject);
        }

        @Override
        public int getKey() {
            return this.packet.getPartitionId();
        }
    }
}

