/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.replicatedmap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.MapPermission;
import java.security.Permission;

public abstract class AbstractReplicatedMapAddEntryListenerMessageTask<Parameter>
extends AbstractCallableMessageTask<Parameter>
implements EntryListener<Object, Object> {
    public AbstractReplicatedMapAddEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)this.getService("hz:impl:replicatedMapService");
        ReplicatedRecordStore recordStore = replicatedMapService.getReplicatedRecordStore(this.getDistributedObjectName(), true);
        Predicate predicate = this.getPredicate();
        String registrationId = predicate == null ? recordStore.addEntryListener(this, this.getKey()) : recordStore.addEntryListener(this, predicate, this.getKey());
        this.endpoint.addListenerDestroyAction("hz:impl:replicatedMapService", this.getDistributedObjectName(), registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "listen");
    }

    public abstract Predicate getPredicate();

    public abstract Data getKey();

    private void handleEvent(EntryEvent<Object, Object> event) {
        if (this.endpoint.isAlive()) {
            Object key = this.serializationService.toData(event.getKey());
            Object newValue = this.serializationService.toData(event.getValue());
            Object oldValue = this.serializationService.toData(event.getOldValue());
            Object mergingValue = this.serializationService.toData(event.getMergingValue());
            ClientMessage clientMessage = this.encodeEvent((Data)key, (Data)newValue, (Data)oldValue, (Data)mergingValue, event.getEventType().getType(), event.getMember().getUuid(), 1);
            this.sendClientMessage(key, clientMessage);
        }
    }

    protected abstract ClientMessage encodeEvent(Data var1, Data var2, Data var3, Data var4, int var5, String var6, int var7);

    @Override
    public void entryAdded(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryRemoved(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryUpdated(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryEvicted(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void mapEvicted(MapEvent event) {
    }

    @Override
    public void mapCleared(MapEvent event) {
    }
}

