/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientInvocationFuture<V>
implements ICompletableFuture<V> {
    static final ILogger LOGGER = Logger.getLogger(ClientInvocationFuture.class);
    private final ClientRequest request;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl clientListenerService;
    private final SerializationService serializationService;
    private final EventHandler handler;
    private final List<ExecutionCallbackNode> callbackNodeList = new LinkedList<ExecutionCallbackNode>();
    private final ClientInvocation invocation;
    private volatile Object response;

    public ClientInvocationFuture(ClientInvocation invocation, HazelcastClientInstanceImpl client, ClientRequest request, EventHandler handler) {
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.clientListenerService = (ClientListenerServiceImpl)client.getListenerService();
        this.serializationService = client.getSerializationService();
        this.request = request;
        this.handler = handler;
        this.invocation = invocation;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exception) {
            throw ExceptionUtil.rethrow(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long waitMillis;
        int heartBeatInterval = this.invocation.getHeartBeatInterval();
        if (this.response == null && (waitMillis = unit.toMillis(timeout)) > 0L) {
            ClientInvocationFuture clientInvocationFuture = this;
            synchronized (clientInvocationFuture) {
                while (waitMillis > 0L && this.response == null) {
                    long start = Clock.currentTimeMillis();
                    this.wait(Math.min((long)heartBeatInterval, waitMillis));
                    long elapsed = Clock.currentTimeMillis() - start;
                    waitMillis -= elapsed;
                    if (this.invocation.isConnectionHealthy(elapsed)) continue;
                    this.invocation.notify(new TargetDisconnectedException());
                }
            }
        }
        return this.resolveResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResponse(Object response) {
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (this.response != null && this.handler == null) {
                LOGGER.warning("The Future.set() method can only be called once. Request: " + this.request + ", current response: " + this.response + ", new response: " + response);
                return;
            }
            if (this.handler != null && !(response instanceof Throwable)) {
                this.handler.onListenerRegister();
            }
            if (this.response != null && !(response instanceof Throwable)) {
                String uuid = (String)this.serializationService.toObject(this.response);
                String alias = (String)this.serializationService.toObject(response);
                this.clientListenerService.reRegisterListener(uuid, alias, this.request.getCallId());
                return;
            }
            this.response = response;
            this.notifyAll();
            for (ExecutionCallbackNode node : this.callbackNodeList) {
                this.runAsynchronous(node.callback, node.executor, node.deserialized);
            }
            this.callbackNodeList.clear();
        }
    }

    private V resolveResponse() throws ExecutionException, TimeoutException, InterruptedException {
        if (this.response instanceof Throwable) {
            ExceptionUtil.fixRemoteStackTrace((Throwable)this.response, Thread.currentThread().getStackTrace());
            if (this.response instanceof ExecutionException) {
                throw (ExecutionException)this.response;
            }
            if (this.response instanceof TimeoutException) {
                throw (TimeoutException)this.response;
            }
            if (this.response instanceof Error) {
                throw (Error)this.response;
            }
            if (this.response instanceof InterruptedException) {
                throw (InterruptedException)this.response;
            }
            throw new ExecutionException((Throwable)this.response);
        }
        if (this.response == null) {
            throw new TimeoutException();
        }
        return (V)this.response;
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.executionService.getAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor, true);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andThenInternal(ExecutionCallback<Data> callback) {
        ExecutorService executor = this.executionService.getAsyncExecutor();
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor, false);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor, false));
        }
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public EventHandler getHandler() {
        return this.handler;
    }

    private void runAsynchronous(final ExecutionCallback callback, Executor executor, final boolean deserialized) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object resp;
                        try {
                            resp = ClientInvocationFuture.this.resolveResponse();
                        }
                        catch (Throwable t) {
                            callback.onFailure(t);
                            return;
                        }
                        if (deserialized) {
                            resp = ClientInvocationFuture.this.serializationService.toObject(resp);
                        }
                        callback.onResponse(resp);
                    }
                    catch (Throwable t) {
                        LOGGER.severe("Failed to execute callback: " + callback + "! Request: " + ClientInvocationFuture.this.request + ", response: " + ClientInvocationFuture.this.response, t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.warning("Execution of callback: " + callback + " is rejected!", e);
        }
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    class ExecutionCallbackNode {
        final ExecutionCallback callback;
        final Executor executor;
        final boolean deserialized;

        ExecutionCallbackNode(ExecutionCallback callback, Executor executor, boolean deserialized) {
            this.callback = callback;
            this.executor = executor;
            this.deserialized = deserialized;
        }
    }
}

