/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractCompletableFuture<V>
implements ICompletableFuture<V> {
    protected static final Object NOT_AVAILABLE_VALUE = new Object();
    protected final NodeEngine nodeEngine;
    protected volatile Object result = NOT_AVAILABLE_VALUE;
    private final Object completionLock = new Object();
    private final ILogger logger;
    private volatile ExecutionCallbackNode<V> callbackHead;

    protected AbstractCompletableFuture(NodeEngine nodeEngine, ILogger logger) {
        this.nodeEngine = nodeEngine;
        this.logger = logger;
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.getAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ValidationUtil.isNotNull(callback, "callback");
        ValidationUtil.isNotNull(executor, "executor");
        if (this.isDoneInternal()) {
            this.runAsynchronous(callback, executor);
            return;
        }
        Object object = this.completionLock;
        synchronized (object) {
            if (this.isDoneInternal()) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackHead = new ExecutionCallbackNode(callback, executor, this.callbackHead);
        }
    }

    @Override
    public boolean isDone() {
        return this.isDoneInternal();
    }

    private boolean isDoneInternal() {
        return this.result != NOT_AVAILABLE_VALUE;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.logger.severe("Unexpected timeout while processing " + this, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object result) {
        ExecutionCallbackNode<V> callbackChain;
        Object object = this.completionLock;
        synchronized (object) {
            if (this.isDoneInternal()) {
                return;
            }
            this.result = result;
            callbackChain = this.callbackHead;
            this.callbackHead = null;
        }
        this.fireCallbacks(callbackChain);
    }

    protected V getResult() {
        Object result = this.result;
        if (result instanceof Throwable) {
            ExceptionUtil.sneakyThrow((Throwable)result);
        }
        return (V)result;
    }

    protected void fireCallbacks(ExecutionCallbackNode<V> callbackChain) {
        while (callbackChain != null) {
            this.runAsynchronous(callbackChain.callback, callbackChain.executor);
            callbackChain = callbackChain.next;
        }
    }

    private void runAsynchronous(final ExecutionCallback<V> callback, Executor executor) {
        try {
            final Object result = this.result;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (result instanceof Throwable) {
                            callback.onFailure((Throwable)result);
                        } else {
                            callback.onResponse(result);
                        }
                    }
                    catch (Throwable cause) {
                        AbstractCompletableFuture.this.logger.severe("Failed asynchronous execution of execution callback: " + callback + "for call " + AbstractCompletableFuture.this, cause);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.logger.warning("Execution of callback: " + callback + " is rejected!", e);
        }
    }

    protected ExecutorService getAsyncExecutor() {
        return this.nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    private static final class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

