/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ArrayWriteBehindQueue
implements WriteBehindQueue<DelayedEntry> {
    private static final int INITIAL_CAPACITY = 16;
    protected List<DelayedEntry> list;

    ArrayWriteBehindQueue() {
        this.list = new ArrayList<DelayedEntry>(16);
    }

    ArrayWriteBehindQueue(List<DelayedEntry> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    @Override
    public boolean offer(DelayedEntry entry) {
        return this.list.add(entry);
    }

    @Override
    public DelayedEntry get(DelayedEntry entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DelayedEntry getFirst() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    @Override
    public void removeFirst() {
        if (this.list.isEmpty()) {
            return;
        }
        this.list.remove(0);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public WriteBehindQueue<DelayedEntry> getSnapShot() {
        if (this.list == null || this.list.isEmpty()) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        return new ArrayWriteBehindQueue(new ArrayList<DelayedEntry>(this.list));
    }

    @Override
    public void addFront(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        ArrayList<DelayedEntry> newList = new ArrayList<DelayedEntry>();
        newList.addAll(collection);
        newList.addAll(this.list);
        this.list = newList;
    }

    @Override
    public void addEnd(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (DelayedEntry e : collection) {
            this.offer(e);
        }
    }

    @Override
    public void removeAll(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.list.isEmpty()) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.list.remove(0);
        }
    }

    @Override
    public List<DelayedEntry> removeAll() {
        List<DelayedEntry> list = this.asList();
        this.list.clear();
        return list;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public List<DelayedEntry> asList() {
        if (this.list.isEmpty()) {
            Collections.emptyList();
        }
        return new ArrayList<DelayedEntry>(this.list);
    }

    @Override
    public List<DelayedEntry> filterItems(long now) {
        ArrayList<DelayedEntry> delayedEntries = null;
        List<DelayedEntry> list = this.list;
        for (DelayedEntry e : list) {
            if (delayedEntries == null) {
                delayedEntries = new ArrayList<DelayedEntry>();
            }
            if (e.getStoreTime() > now) continue;
            delayedEntries.add(e);
        }
        if (delayedEntries == null) {
            return Collections.emptyList();
        }
        return delayedEntries;
    }

    @Override
    public List<DelayedEntry> get(int count) {
        if (count <= 0) {
            return Collections.emptyList();
        }
        List<DelayedEntry> values = this.list;
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DelayedEntry> delayedEntries = new ArrayList<DelayedEntry>(count);
        for (DelayedEntry e : values) {
            if (delayedEntries.size() == count) break;
            delayedEntries.add(e);
        }
        return delayedEntries;
    }
}

