/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreManager;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.StoreEvent;
import com.hazelcast.map.impl.mapstore.writebehind.StoreListener;
import com.hazelcast.map.impl.mapstore.writebehind.StoreWorker;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessors;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.executor.ExecutorType;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WriteBehindManager
implements MapStoreManager {
    private static final String EXECUTOR_NAME_PREFIX = "hz:scheduled:mapstore:";
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private final ScheduledExecutorService scheduledExecutor;
    private WriteBehindProcessor writeBehindProcessor;
    private StoreWorker storeWorker;
    private String executorName;
    private final MapStoreContext mapStoreContext;

    public WriteBehindManager(MapStoreContext mapStoreContext) {
        this.mapStoreContext = mapStoreContext;
        this.writeBehindProcessor = this.newWriteBehindProcessor(mapStoreContext);
        this.storeWorker = new StoreWorker(mapStoreContext, this.writeBehindProcessor);
        this.executorName = EXECUTOR_NAME_PREFIX + mapStoreContext.getMapName();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        this.scheduledExecutor = this.getScheduledExecutorService(mapServiceContext);
    }

    @Override
    public void start() {
        this.scheduledExecutor.scheduleAtFixedRate(this.storeWorker, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        MapServiceContext mapServiceContext = this.mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        nodeEngine.getExecutionService().shutdownExecutor(this.executorName);
    }

    @Override
    public MapDataStore getMapDataStore(int partitionId) {
        return MapDataStores.createWriteBehindStore(this.mapStoreContext, partitionId, this.writeBehindProcessor);
    }

    private WriteBehindProcessor newWriteBehindProcessor(MapStoreContext mapStoreContext) {
        WriteBehindProcessor writeBehindProcessor = WriteBehindProcessors.createWriteBehindProcessor(mapStoreContext);
        InternalStoreListener storeListener = new InternalStoreListener(mapStoreContext);
        writeBehindProcessor.addStoreListener(storeListener);
        return writeBehindProcessor;
    }

    private ScheduledExecutorService getScheduledExecutorService(MapServiceContext mapServiceContext) {
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(this.executorName, 1, 10000, ExecutorType.CACHED);
        return executionService.getScheduledExecutor(this.executorName);
    }

    private static class InternalStoreListener
    implements StoreListener<DelayedEntry> {
        private final MapStoreContext mapStoreContext;

        public InternalStoreListener(MapStoreContext mapStoreContext) {
            this.mapStoreContext = mapStoreContext;
        }

        @Override
        public void beforeStore(StoreEvent<DelayedEntry> storeEvent) {
        }

        @Override
        public void afterStore(StoreEvent<DelayedEntry> storeEvent) {
            DelayedEntry delayedEntry = storeEvent.getSource();
            int partitionId = delayedEntry.getPartitionId();
            WriteBehindStore writeBehindStore = this.getWriteBehindStoreOrNull(partitionId);
            if (writeBehindStore == null) {
                return;
            }
            Data key = (Data)delayedEntry.getKey();
            Object value = delayedEntry.getValue();
            writeBehindStore.removeFromStagingArea(key, value);
            if (value == null) {
                writeBehindStore.removeFromWaitingDeletions(key);
            }
        }

        private WriteBehindStore getWriteBehindStoreOrNull(int partitionId) {
            MapStoreContext mapStoreContext = this.mapStoreContext;
            MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
            PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
            RecordStore recordStore = partitionContainer.getExistingRecordStore(mapStoreContext.getMapName());
            if (recordStore == null) {
                return null;
            }
            return (WriteBehindStore)recordStore.getMapDataStore();
        }
    }
}

