/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.NearCache;
import com.hazelcast.map.impl.SizeEstimator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class NearCacheSizeEstimator
implements SizeEstimator<NearCache.CacheRecord> {
    private static final AtomicLongFieldUpdater<NearCacheSizeEstimator> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(NearCacheSizeEstimator.class, "size");
    private volatile long size;

    protected NearCacheSizeEstimator() {
    }

    @Override
    public long getCost(NearCache.CacheRecord record) {
        if (record == null) {
            return 0L;
        }
        long cost = record.getCost();
        if (cost == 0L) {
            return 0L;
        }
        int numberOfIntegers = 4;
        long size = 0L;
        size += 16L;
        return size += cost;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void add(long size) {
        SIZE_UPDATER.addAndGet(this, size);
    }

    @Override
    public void reset() {
        SIZE_UPDATER.set(this, 0L);
    }
}

