/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CacheEvictionConfig;
import com.hazelcast.config.CacheSimpleConfigReadOnly;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import java.util.ArrayList;
import java.util.List;

public class CacheSimpleConfig {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.LRU;
    private String name;
    private String keyType;
    private String valueType;
    private boolean statisticsEnabled;
    private boolean managementEnabled;
    private boolean readThrough;
    private boolean writeThrough;
    private String cacheLoaderFactory;
    private String cacheWriterFactory;
    private String expiryPolicyFactory;
    private List<CacheSimpleEntryListenerConfig> cacheEntryListeners;
    private int asyncBackupCount = 0;
    private int backupCount = 1;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private CacheEvictionConfig evictionConfig = new CacheEvictionConfig();
    private CacheSimpleConfig readOnly;

    public CacheSimpleConfig(CacheSimpleConfig cacheSimpleConfig) {
        this.name = cacheSimpleConfig.name;
        this.keyType = cacheSimpleConfig.keyType;
        this.valueType = cacheSimpleConfig.valueType;
        this.statisticsEnabled = cacheSimpleConfig.statisticsEnabled;
        this.managementEnabled = cacheSimpleConfig.managementEnabled;
        this.readThrough = cacheSimpleConfig.readThrough;
        this.writeThrough = cacheSimpleConfig.writeThrough;
        this.cacheLoaderFactory = cacheSimpleConfig.cacheLoaderFactory;
        this.cacheWriterFactory = cacheSimpleConfig.cacheWriterFactory;
        this.expiryPolicyFactory = cacheSimpleConfig.expiryPolicyFactory;
        this.cacheEntryListeners = cacheSimpleConfig.cacheEntryListeners;
        this.asyncBackupCount = cacheSimpleConfig.asyncBackupCount;
        this.backupCount = cacheSimpleConfig.backupCount;
        this.inMemoryFormat = cacheSimpleConfig.inMemoryFormat;
        if (this.evictionConfig != null) {
            this.evictionConfig = cacheSimpleConfig.evictionConfig;
        }
    }

    public CacheSimpleConfig() {
    }

    public CacheSimpleConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new CacheSimpleConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public CacheSimpleConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public CacheSimpleConfig setKeyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public String getValueType() {
        return this.valueType;
    }

    public CacheSimpleConfig setValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public CacheSimpleConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public CacheSimpleConfig setManagementEnabled(boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
        return this;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public CacheSimpleConfig setReadThrough(boolean readThrough) {
        this.readThrough = readThrough;
        return this;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public CacheSimpleConfig setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
        return this;
    }

    public String getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public CacheSimpleConfig setCacheLoaderFactory(String cacheLoaderFactory) {
        this.cacheLoaderFactory = cacheLoaderFactory;
        return this;
    }

    public String getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public CacheSimpleConfig setCacheWriterFactory(String cacheWriterFactory) {
        this.cacheWriterFactory = cacheWriterFactory;
        return this;
    }

    public String getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public CacheSimpleConfig setExpiryPolicyFactory(String expiryPolicyFactory) {
        this.expiryPolicyFactory = expiryPolicyFactory;
        return this;
    }

    public CacheSimpleConfig addEntryListenerConfig(CacheSimpleEntryListenerConfig listenerConfig) {
        this.getCacheEntryListeners().add(listenerConfig);
        return this;
    }

    public List<CacheSimpleEntryListenerConfig> getCacheEntryListeners() {
        if (this.cacheEntryListeners == null) {
            this.cacheEntryListeners = new ArrayList<CacheSimpleEntryListenerConfig>();
        }
        return this.cacheEntryListeners;
    }

    public CacheSimpleConfig setCacheEntryListeners(List<CacheSimpleEntryListenerConfig> cacheEntryListeners) {
        this.cacheEntryListeners = cacheEntryListeners;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public CacheSimpleConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public CacheSimpleConfig setBackupCount(int backupCount) {
        this.backupCount = backupCount;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public CacheSimpleConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public CacheEvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public CacheSimpleConfig setEvictionConfig(CacheEvictionConfig evictionConfig) {
        if (evictionConfig != null) {
            this.evictionConfig = evictionConfig;
        }
        return this;
    }
}

