/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.client;

import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.executor.impl.CallableTaskOperation;
import com.hazelcast.executor.impl.ExecutorPortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.Callable;

public class PartitionCallableRequest
extends PartitionClientRequest {
    private String name;
    private String uuid;
    private Callable callable;
    private int partitionId;

    public PartitionCallableRequest() {
    }

    public PartitionCallableRequest(String name, String uuid, Callable callable, int partitionId) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
        this.partitionId = partitionId;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            this.callable = securityContext.createSecureCallable(this.getEndpoint().getSubject(), this.callable);
        }
        return new CallableTaskOperation(this.name, this.uuid, this.callable);
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("u", this.uuid);
        writer.writeInt("p", this.partitionId);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.callable);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.uuid = reader.readUTF("u");
        this.partitionId = reader.readInt("p");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.callable = (Callable)rawDataInput.readObject();
    }
}

