/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.mapstore.writebehind;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.MapStore;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.mapstore.writebehind.DefaultWriteBehindProcessor;
import com.hazelcast.map.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class AbstractWriteBehindProcessor<T>
implements WriteBehindProcessor<T> {
    protected final int writeBatchSize;
    protected final boolean writeCoalescing;
    protected final ILogger logger;
    protected final MapStore mapStore;
    private final SerializationService serializationService;

    public AbstractWriteBehindProcessor(MapContainer mapContainer) {
        this.serializationService = mapContainer.getMapServiceContext().getNodeEngine().getSerializationService();
        this.mapStore = mapContainer.getStore();
        this.logger = mapContainer.getMapServiceContext().getNodeEngine().getLogger(DefaultWriteBehindProcessor.class);
        MapStoreConfig mapStoreConfig = mapContainer.getMapConfig().getMapStoreConfig();
        this.writeBatchSize = mapStoreConfig.getWriteBatchSize();
        this.writeCoalescing = mapStoreConfig.isWriteCoalescing();
    }

    protected Object toObject(Object obj) {
        return this.serializationService.toObject(obj);
    }

    protected Data toData(Object obj) {
        return this.serializationService.toData(obj);
    }

    protected void sleepSeconds(long secs) {
        try {
            TimeUnit.SECONDS.sleep(secs);
        }
        catch (InterruptedException e) {
            this.logger.warning(e);
        }
    }

    protected static enum StoreOperationType {
        DELETE{

            @Override
            boolean processSingle(Object key, Object value, MapStore mapStore) {
                mapStore.delete(key);
                return true;
            }

            @Override
            boolean processBatch(Map map, MapStore mapStore) {
                mapStore.deleteAll(map.keySet());
                return true;
            }
        }
        ,
        WRITE{

            @Override
            boolean processSingle(Object key, Object value, MapStore mapStore) {
                mapStore.store(key, value);
                return true;
            }

            @Override
            boolean processBatch(Map map, MapStore mapStore) {
                mapStore.storeAll(map);
                return true;
            }
        };


        abstract boolean processSingle(Object var1, Object var2, MapStore var3);

        abstract boolean processBatch(Map var1, MapStore var2);
    }
}

