/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.operation.CacheClearOperationFactory;
import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheClearRequest
extends AllPartitionsClientRequest
implements RetryableRequest {
    private String name;
    private Set<Data> keys;
    private boolean isRemoveAll;
    private int completionId;

    public CacheClearRequest() {
    }

    public CacheClearRequest(String name, Set<Data> keys, boolean isRemoveAll, int completionId) {
        this.name = name;
        this.keys = keys;
        this.isRemoveAll = isRemoveAll;
        this.completionId = completionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("c", this.completionId);
        writer.writeBoolean("r", this.isRemoveAll);
        writer.writeBoolean("k", this.keys != null);
        if (this.keys != null && !this.keys.isEmpty()) {
            ObjectDataOutput output = writer.getRawDataOutput();
            output.writeInt(this.keys.size());
            for (Data key : this.keys) {
                key.writeData(output);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.completionId = reader.readInt("c");
        this.isRemoveAll = reader.readBoolean("r");
        boolean isKeysNotNull = reader.readBoolean("k");
        if (isKeysNotNull) {
            ObjectDataInput input = reader.getRawDataInput();
            int size = input.readInt();
            this.keys = new HashSet<Data>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    Data key = new Data();
                    key.readData(input);
                    this.keys.add(key);
                }
            }
        }
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new CacheClearOperationFactory(this.name, this.keys, this.isRemoveAll, this.completionId);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        return map;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

