/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapContainsValueRequest
extends AbstractReplicatedMapClientRequest {
    private Object value;

    ClientReplicatedMapContainsValueRequest() {
        super(null);
    }

    public ClientReplicatedMapContainsValueRequest(String mapName, Object value) {
        super(mapName);
        this.value = value;
    }

    public Object call() throws Exception {
        ReplicatedRecordStore recordStore = this.getReplicatedRecordStore();
        return recordStore.containsValue(this.value);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readObject();
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "read");
    }

    @Override
    public String getMethodName() {
        return "containsValue";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

