/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.concurrent.lock.client.AbstractUnlockRequest;
import com.hazelcast.multimap.MultiMapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MultiMapUnlockRequest
extends AbstractUnlockRequest {
    String name;

    public MultiMapUnlockRequest() {
    }

    public MultiMapUnlockRequest(Data key, long threadId, String name) {
        super(key, threadId);
        this.name = name;
    }

    public MultiMapUnlockRequest(Data key, long threadId, boolean force, String name) {
        super(key, threadId, force);
        this.name = name;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:multiMapService", this.name);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.read(reader);
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "lock");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getDistributedObjectType() {
        return "hz:impl:multiMapService";
    }
}

