/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.multimap.operations.EntrySetResponse;
import com.hazelcast.multimap.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.operations.client.MultiMapAllPartitionRequest;
import com.hazelcast.multimap.operations.client.PortableEntrySetResponse;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.OperationFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntrySetRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    public EntrySetRequest() {
    }

    public EntrySetRequest(String name) {
        super(name);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.ENTRY_SET);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Map.Entry> entrySet = new HashSet<Map.Entry>();
        for (Object obj : map.values()) {
            if (obj == null) continue;
            EntrySetResponse response = (EntrySetResponse)obj;
            Set<Map.Entry<Data, Data>> entries = response.getDataEntrySet();
            entrySet.addAll(entries);
        }
        return new PortableEntrySetResponse(entrySet);
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public String getMethodName() {
        return "entrySet";
    }
}

