/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class PartitionWideEntryOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    private static final EntryEventType NO_NEED_TO_FIRE_EVENT = null;
    EntryProcessor entryProcessor;
    MapEntrySet response;

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        ManagedContext managedContext = this.getNodeEngine().getSerializationService().getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        this.response = new MapEntrySet();
        RecordStore recordStore = this.mapService.getMapServiceContext().getRecordStore(this.getPartitionId(), this.name);
        LocalMapStatsImpl mapStats = this.mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name);
        Map<Data, Record> records = recordStore.getReadonlyRecordMap();
        for (Map.Entry<Data, Record> recordEntry : records.entrySet()) {
            EntryEventType eventType;
            long start = System.currentTimeMillis();
            Data dataKey = recordEntry.getKey();
            Record record = recordEntry.getValue();
            Object valueBeforeProcess = record.getValue();
            Object valueBeforeProcessObject = this.mapService.getMapServiceContext().toObject(valueBeforeProcess);
            Object objectKey = this.mapService.getMapServiceContext().toObject(record.getKey());
            if (this.getPredicate() != null) {
                SerializationService ss = this.getNodeEngine().getSerializationService();
                QueryEntry queryEntry = new QueryEntry(ss, dataKey, objectKey, valueBeforeProcessObject);
                if (!this.getPredicate().apply(queryEntry)) continue;
            }
            MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(objectKey, valueBeforeProcessObject);
            Object result = this.entryProcessor.process(entry);
            Object valueAfterProcess = entry.getValue();
            Data dataValue = null;
            if (result != null) {
                dataValue = this.mapService.getMapServiceContext().toData(result);
                this.response.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, dataValue));
            }
            if (valueAfterProcess == null) {
                recordStore.remove(dataKey);
                mapStats.incrementRemoves(this.getLatencyFrom(start));
                eventType = EntryEventType.REMOVED;
            } else {
                if (valueBeforeProcessObject == null) {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.ADDED;
                } else if (!entry.isModified()) {
                    mapStats.incrementGets(this.getLatencyFrom(start));
                    eventType = NO_NEED_TO_FIRE_EVENT;
                } else {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.UPDATED;
                }
                if (eventType != NO_NEED_TO_FIRE_EVENT) {
                    recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, valueAfterProcess));
                }
            }
            this.fireEvent(dataKey, dataValue, valueBeforeProcess, valueAfterProcess, recordStore, eventType);
        }
    }

    private void fireEvent(Data dataKey, Data dataValue, Object valueBeforeProcess, Object valueAfterProcess, RecordStore recordStore, EntryEventType eventType) {
        if (eventType == NO_NEED_TO_FIRE_EVENT) {
            return;
        }
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        Data oldValue = mapServiceContext.toData(valueBeforeProcess);
        Data value = mapServiceContext.toData(valueAfterProcess);
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, oldValue, value);
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(this.name)) {
            nearCacheProvider.invalidateAllNearCaches(this.name, dataKey);
        }
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                mapEventPublisher.publishWanReplicationRemove(this.name, dataKey, Clock.currentTimeMillis());
            } else {
                Record r = recordStore.getRecord(dataKey);
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(dataKey, dataValue, r);
                mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    public String toString() {
        return "PartitionWideEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new PartitionWideEntryBackupOperation(this.name, backupProcessor) : null;
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }
}

