/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.MapReplicationOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import java.util.List;

class MapMigrationAwareService
implements MigrationAwareService {
    private MapServiceContext mapServiceContext;
    private SerializationService serializationService;

    public MapMigrationAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.serializationService = mapServiceContext.getNodeEngine().getSerializationService();
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        MapReplicationOperation operation = new MapReplicationOperation(this.mapServiceContext.getService(), container, event.getPartitionId(), event.getReplicaIndex());
        operation.setService(this.mapServiceContext.getService());
        return operation.isEmpty() ? null : operation;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrateIndex(event);
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.mapServiceContext.clearPartitionData(event.getPartitionId());
        }
        List<Integer> memberPartitions = this.mapServiceContext.getMemberPartitions();
        this.mapServiceContext.ownedPartitions().set(memberPartitions);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.mapServiceContext.clearPartitionData(event.getPartitionId());
        }
        List<Integer> memberPartitions = this.mapServiceContext.getMemberPartitions();
        this.mapServiceContext.ownedPartitions().set(memberPartitions);
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.mapServiceContext.clearPartitionData(partitionId);
    }

    private void migrateIndex(PartitionMigrationEvent event) {
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            IndexService indexService = mapContainer.getIndexService();
            if (!indexService.hasIndex()) continue;
            for (Record record : recordStore.getReadonlyRecordMap().values()) {
                if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
                    indexService.removeEntryIndex(record.getKey());
                    continue;
                }
                Object value = record.getValue();
                if (value == null) continue;
                indexService.saveEntryIndex(new QueryEntry(this.serializationService, record.getKey(), record.getKey(), value));
            }
        }
    }
}

