/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.scheduler;

import com.hazelcast.util.Clock;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import com.hazelcast.util.scheduler.TimeKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class SecondsBasedEntryTaskScheduler<K, V>
implements EntryTaskScheduler<K, V> {
    public static final int INITIAL_CAPACITY = 10;
    public static final double FACTOR = 1000.0;
    private static final long INITIAL_TIME_MILLIS = Clock.currentTimeMillis();
    private static final Comparator<ScheduledEntry> SCHEDULED_ENTRIES_COMPARATOR = new Comparator<ScheduledEntry>(){

        @Override
        public int compare(ScheduledEntry o1, ScheduledEntry o2) {
            if (o1.getScheduleStartTimeInNanos() > o2.getScheduleStartTimeInNanos()) {
                return 1;
            }
            if (o1.getScheduleStartTimeInNanos() < o2.getScheduleStartTimeInNanos()) {
                return -1;
            }
            return 0;
        }
    };
    private final ConcurrentMap<Object, Integer> secondsOfKeys = new ConcurrentHashMap<Object, Integer>(1000);
    private final ConcurrentMap<Integer, ConcurrentMap<Object, ScheduledEntry<K, V>>> scheduledEntries = new ConcurrentHashMap<Integer, ConcurrentMap<Object, ScheduledEntry<K, V>>>(1000);
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledEntryProcessor entryProcessor;
    private final ScheduleType scheduleType;
    private final ConcurrentMap<Integer, ScheduledFuture> scheduledTaskMap = new ConcurrentHashMap<Integer, ScheduledFuture>(1000);

    SecondsBasedEntryTaskScheduler(ScheduledExecutorService scheduledExecutorService, ScheduledEntryProcessor entryProcessor, ScheduleType scheduleType) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.entryProcessor = entryProcessor;
        this.scheduleType = scheduleType;
    }

    @Override
    public boolean schedule(long delayMillis, K key, V value) {
        if (this.scheduleType.equals((Object)ScheduleType.POSTPONE)) {
            return this.schedulePostponeEntry(delayMillis, key, value);
        }
        if (this.scheduleType.equals((Object)ScheduleType.SCHEDULE_IF_NEW)) {
            return this.scheduleIfNew(delayMillis, key, value);
        }
        if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
            return this.scheduleEntry(delayMillis, key, value);
        }
        throw new RuntimeException("Undefined schedule type.");
    }

    @Override
    public Set<K> flush(Set<K> keys) {
        if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
            return this.flushComparingTimeKeys(keys);
        }
        HashSet<ScheduledEntry<K, V>> res = new HashSet<ScheduledEntry<K, V>>(keys.size());
        HashSet<K> processedKeys = new HashSet<K>();
        for (K key : keys) {
            ConcurrentMap entries;
            Integer second = (Integer)this.secondsOfKeys.remove(key);
            if (second == null || (entries = (ConcurrentMap)this.scheduledEntries.get(second)) == null) continue;
            processedKeys.add(key);
            res.add((ScheduledEntry<K, V>)entries.remove(key));
        }
        this.entryProcessor.process(this, this.sortForEntryProcessing(res));
        return processedKeys;
    }

    private Set flushComparingTimeKeys(Set keys) {
        HashSet<ScheduledEntry<K, V>> res = new HashSet<ScheduledEntry<K, V>>(keys.size());
        HashSet<TimeKey> candidateKeys = new HashSet<TimeKey>();
        HashSet<Object> processedKeys = new HashSet<Object>();
        for (Object key : keys) {
            for (Object skey : this.secondsOfKeys.keySet()) {
                TimeKey timeKey = (TimeKey)skey;
                if (!key.equals(timeKey.getKey())) continue;
                candidateKeys.add(timeKey);
            }
        }
        for (TimeKey timeKey : candidateKeys) {
            ConcurrentMap entries;
            Integer second = (Integer)this.secondsOfKeys.remove(timeKey);
            if (second == null || (entries = (ConcurrentMap)this.scheduledEntries.get(second)) == null) continue;
            res.add((ScheduledEntry<K, V>)entries.remove(timeKey));
            processedKeys.add(timeKey.getKey());
        }
        this.entryProcessor.process(this, this.sortForEntryProcessing(res));
        return processedKeys;
    }

    @Override
    public ScheduledEntry<K, V> cancel(K key) {
        ScheduledFuture removed;
        if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
            return this.cancelComparingTimeKey(key);
        }
        Integer second = (Integer)this.secondsOfKeys.remove(key);
        if (second == null) {
            return null;
        }
        ConcurrentMap entries = (ConcurrentMap)this.scheduledEntries.get(second);
        if (entries == null) {
            return null;
        }
        ScheduledEntry result = (ScheduledEntry)entries.remove(key);
        if (entries.isEmpty() && (removed = (ScheduledFuture)this.scheduledTaskMap.remove(second)) != null) {
            removed.cancel(false);
        }
        return result;
    }

    @Override
    public ScheduledEntry<K, V> get(K key) {
        ConcurrentMap entries;
        if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
            return this.getComparingTimeKey(key);
        }
        Integer second = (Integer)this.secondsOfKeys.get(key);
        if (second != null && (entries = (ConcurrentMap)this.scheduledEntries.get(second)) != null) {
            return (ScheduledEntry)entries.get(key);
        }
        return null;
    }

    public ScheduledEntry<K, V> cancelComparingTimeKey(K key) {
        HashSet<TimeKey> candidateKeys = new HashSet<TimeKey>();
        for (Object tkey : this.secondsOfKeys.keySet()) {
            TimeKey timeKey = (TimeKey)tkey;
            if (!timeKey.getKey().equals(key)) continue;
            candidateKeys.add(timeKey);
        }
        ScheduledEntry result = null;
        for (TimeKey timeKey : candidateKeys) {
            ScheduledFuture removed;
            ConcurrentMap entries;
            Integer second = (Integer)this.secondsOfKeys.remove(timeKey);
            if (second == null || (entries = (ConcurrentMap)this.scheduledEntries.get(second)) == null) continue;
            result = (ScheduledEntry)entries.remove(timeKey);
            if (!entries.isEmpty() || (removed = (ScheduledFuture)this.scheduledTaskMap.remove(second)) == null) continue;
            removed.cancel(false);
        }
        return result;
    }

    public ScheduledEntry<K, V> getComparingTimeKey(K key) {
        HashSet<TimeKey> candidateKeys = new HashSet<TimeKey>();
        for (Object tkey : this.secondsOfKeys.keySet()) {
            TimeKey timeKey = (TimeKey)tkey;
            if (!timeKey.getKey().equals(key)) continue;
            candidateKeys.add(timeKey);
        }
        ScheduledEntry result = null;
        for (TimeKey timeKey : candidateKeys) {
            ConcurrentMap entries;
            Integer second = (Integer)this.secondsOfKeys.get(timeKey);
            if (second == null || (entries = (ConcurrentMap)this.scheduledEntries.get(second)) == null) continue;
            result = (ScheduledEntry)entries.get(timeKey);
        }
        return result;
    }

    private boolean schedulePostponeEntry(long delayMillis, K key, V value) {
        int delaySeconds = this.ceilToSecond(delayMillis);
        Integer newSecond = this.findRelativeSecond(delayMillis);
        Integer existingSecond = this.secondsOfKeys.put(key, newSecond);
        if (existingSecond != null) {
            if (existingSecond.equals(newSecond)) {
                return false;
            }
            this.removeKeyFromSecond(key, existingSecond);
        }
        this.doSchedule(key, new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds), newSecond);
        return true;
    }

    private boolean scheduleEntry(long delayMillis, K key, V value) {
        int delaySeconds = this.ceilToSecond(delayMillis);
        Integer newSecond = this.findRelativeSecond(delayMillis);
        long time = System.nanoTime();
        TimeKey timeKey = new TimeKey(key, time);
        this.secondsOfKeys.put(timeKey, newSecond);
        this.doSchedule(timeKey, new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds, time), newSecond);
        return true;
    }

    private boolean scheduleIfNew(long delayMillis, K key, V value) {
        int delaySeconds = this.ceilToSecond(delayMillis);
        Integer newSecond = this.findRelativeSecond(delayMillis);
        if (this.secondsOfKeys.putIfAbsent(key, newSecond) != null) {
            return false;
        }
        this.doSchedule(key, new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds), newSecond);
        return true;
    }

    private int findRelativeSecond(long delayMillis) {
        long now = Clock.currentTimeMillis();
        long d = now + delayMillis - INITIAL_TIME_MILLIS;
        return this.ceilToSecond(d);
    }

    private int ceilToSecond(long delayMillis) {
        return (int)Math.ceil((double)delayMillis / 1000.0);
    }

    private void doSchedule(Object mapKey, ScheduledEntry<K, V> entry, Integer second) {
        ConcurrentMap<Object, ScheduledEntry<Object, ScheduledEntry<K, V>>> entries = (ConcurrentHashMap<Object, ScheduledEntry<Object, ScheduledEntry<K, V>>>)this.scheduledEntries.get(second);
        boolean shouldSchedule = false;
        if (entries == null) {
            entries = new ConcurrentHashMap<Object, ScheduledEntry<Object, ScheduledEntry<K, V>>>(10);
            ConcurrentMap existingScheduleKeys = this.scheduledEntries.putIfAbsent(second, entries);
            if (existingScheduleKeys != null) {
                entries = existingScheduleKeys;
            } else {
                shouldSchedule = true;
            }
        }
        entries.put(mapKey, entry);
        if (shouldSchedule) {
            this.schedule(second, entry.getActualDelaySeconds());
        }
    }

    private void removeKeyFromSecond(Object key, Integer existingSecond) {
        ConcurrentMap scheduledKeys = (ConcurrentMap)this.scheduledEntries.get(existingSecond);
        if (scheduledKeys != null) {
            ScheduledFuture removed;
            scheduledKeys.remove(key);
            if (scheduledKeys.isEmpty() && (removed = (ScheduledFuture)this.scheduledTaskMap.remove(existingSecond)) != null) {
                removed.cancel(false);
            }
        }
    }

    private void schedule(Integer second, int delaySeconds) {
        EntryProcessorExecutor command = new EntryProcessorExecutor(second);
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(command, (long)delaySeconds, TimeUnit.SECONDS);
        this.scheduledTaskMap.put(second, scheduledFuture);
    }

    private List<ScheduledEntry<K, V>> sortForEntryProcessing(Set<ScheduledEntry<K, V>> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ScheduledEntry<K, V>> sortedEntries = new ArrayList<ScheduledEntry<K, V>>(coll);
        Collections.sort(sortedEntries, SCHEDULED_ENTRIES_COMPARATOR);
        return sortedEntries;
    }

    @Override
    public int size() {
        return this.secondsOfKeys.size();
    }

    @Override
    public void cancelAll() {
        this.secondsOfKeys.clear();
        this.scheduledEntries.clear();
        for (ScheduledFuture task : this.scheduledTaskMap.values()) {
            task.cancel(false);
        }
        this.scheduledTaskMap.clear();
    }

    public String toString() {
        return "EntryTaskScheduler{secondsOfKeys=" + this.secondsOfKeys.size() + ", scheduledEntries [" + this.scheduledEntries.size() + "] =" + this.scheduledEntries.keySet() + '}';
    }

    private final class EntryProcessorExecutor
    implements Runnable {
        private final Integer second;

        private EntryProcessorExecutor(Integer second) {
            this.second = second;
        }

        @Override
        public void run() {
            SecondsBasedEntryTaskScheduler.this.scheduledTaskMap.remove(this.second);
            Map entries = (Map)SecondsBasedEntryTaskScheduler.this.scheduledEntries.remove(this.second);
            if (entries == null || entries.isEmpty()) {
                return;
            }
            HashSet values = new HashSet(entries.size());
            for (Map.Entry entry : entries.entrySet()) {
                Integer removed = (Integer)SecondsBasedEntryTaskScheduler.this.secondsOfKeys.remove(entry.getKey());
                if (removed == null) continue;
                values.add(entry.getValue());
            }
            SecondsBasedEntryTaskScheduler.this.entryProcessor.process(SecondsBasedEntryTaskScheduler.this, SecondsBasedEntryTaskScheduler.this.sortForEntryProcessing(values));
        }
    }
}

