/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.util.EmptyStatement;
import java.io.InputStream;
import java.util.Properties;

public final class HazelcastUtil {
    private static final String VERSION;
    private static final boolean ENTERPRISE;
    private static final String BUILD;
    private static final int BUILD_NUMBER;

    private HazelcastUtil() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getBuild() {
        return BUILD;
    }

    public static int getBuildNumber() {
        return BUILD_NUMBER;
    }

    public static boolean isEnterprise() {
        return ENTERPRISE;
    }

    static {
        String version = System.getProperty("hazelcast.version", "unknown");
        String build = System.getProperty("hazelcast.build", "unknown");
        int buildNumber = 0;
        if ("unknown".equals(version) || "unknown".equals(build)) {
            try {
                InputStream inRuntimeProperties = NodeInitializer.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
                if (inRuntimeProperties != null) {
                    Properties runtimeProperties = new Properties();
                    runtimeProperties.load(inRuntimeProperties);
                    inRuntimeProperties.close();
                    version = runtimeProperties.getProperty("hazelcast.version");
                    build = runtimeProperties.getProperty("hazelcast.build");
                }
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        try {
            buildNumber = Integer.getInteger("hazelcast.build", -1);
            if (buildNumber == -1) {
                buildNumber = Integer.parseInt(build);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        VERSION = version;
        BUILD = build;
        BUILD_NUMBER = buildNumber;
        ENTERPRISE = version.endsWith("-ee");
    }
}

