/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapContainsKeyRequest
extends AbstractReplicatedMapClientRequest {
    private Object key;

    ClientReplicatedMapContainsKeyRequest() {
        super(null);
    }

    public ClientReplicatedMapContainsKeyRequest(String mapName, Object key) {
        super(mapName);
        this.key = key;
    }

    public Object call() throws Exception {
        ReplicatedRecordStore recordStore = this.getReplicatedRecordStore();
        return recordStore.containsKey(this.key);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readObject();
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "read");
    }
}

