/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.tx.TxnPollBackupOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class TxnPollOperation
extends QueueBackupAwareOperation
implements Notifier {
    private long itemId;
    private Data data;

    public TxnPollOperation() {
    }

    public TxnPollOperation(String name, long itemId) {
        super(name);
        this.itemId = itemId;
    }

    @Override
    public void run() throws Exception {
        QueueContainer container = this.getOrCreateContainer();
        this.data = container.txnCommitPoll(this.itemId);
        this.response = this.data != null;
    }

    @Override
    public void afterRun() throws Exception {
        LocalQueueStatsImpl queueStats = this.getQueueService().getLocalQueueStatsImpl(this.name);
        if (this.response != null) {
            queueStats.incrementPolls();
            this.publishEvent(ItemEventType.REMOVED, this.data);
        } else {
            queueStats.incrementEmptyPolls();
        }
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        QueueContainer container = this.getOrCreateContainer();
        return container.getOfferWaitNotifyKey();
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnPollBackupOperation(this.name, this.itemId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
    }

    @Override
    public int getId() {
        return 26;
    }
}

