/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.DrainOperation;
import com.hazelcast.queue.client.QueueRequest;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.SerializableCollection;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;

public class DrainRequest
extends QueueRequest {
    private int maxSize;

    public DrainRequest() {
    }

    public DrainRequest(String name, int maxSize) {
        super(name);
        this.maxSize = maxSize;
    }

    @Override
    protected Operation prepareOperation() {
        return new DrainOperation(this.name, this.maxSize);
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof SerializableCollection) {
            Collection<Data> coll = ((SerializableCollection)response).getCollection();
            return new PortableCollection(coll);
        }
        return super.filter(response);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("m", this.maxSize);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.maxSize = reader.readInt("m");
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "remove");
    }
}

