/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.EntryEventData;
import com.hazelcast.map.MapEventData;
import com.hazelcast.multimap.MultiMapEventFilter;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;

public class MultiMapEventsPublisher {
    private final NodeEngine nodeEngine;

    public MultiMapEventsPublisher(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public void publishMultiMapEvent(String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:multiMapService", mapName);
        if (registrations.isEmpty()) {
            return;
        }
        Address caller = this.nodeEngine.getThisAddress();
        String source = caller.toString();
        MapEventData mapEventData = new MapEventData(source, mapName, caller, eventType.getType(), numberOfEntriesAffected);
        eventService.publishEvent("hz:impl:multiMapService", registrations, (Object)mapEventData, mapName.hashCode());
    }

    public final void publishEntryEvent(String multiMapName, EntryEventType eventType, Data key, Object value) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:multiMapService", multiMapName);
        for (EventRegistration registration : registrations) {
            MultiMapEventFilter filter = (MultiMapEventFilter)registration.getFilter();
            if (filter.getKey() != null && !filter.getKey().equals(key)) continue;
            Data dataValue = filter.isIncludeValue() ? this.nodeEngine.toData(value) : null;
            Address caller = this.nodeEngine.getThisAddress();
            String source = caller.toString();
            EntryEventData event = new EntryEventData(source, multiMapName, caller, key, dataValue, null, eventType.getType());
            eventService.publishEvent("hz:impl:multiMapService", registration, (Object)event, multiMapName.hashCode());
        }
    }
}

