/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.AbstractDelayedEntry;

public final class DelayedEntry<K, V>
extends AbstractDelayedEntry<K> {
    private static final Object NULL_VALUE = new Object();
    private final V value;

    private DelayedEntry(K key, V value, long storeTime, int partitionId) {
        super(key, storeTime, partitionId);
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> DelayedEntry<K, V> create(K key, V value, long storeTime, int partitionId) {
        return new DelayedEntry<K, V>(key, value, storeTime, partitionId);
    }

    public static <K, V> DelayedEntry<K, V> create(K key, V value, long storeTime) {
        return new DelayedEntry<K, V>(key, value, storeTime, -1);
    }

    public static <K, V> DelayedEntry<K, V> createWithNullKey(V value, long storeTime) {
        return new DelayedEntry<Object, V>(null, value, storeTime, 0);
    }

    public static <K, V> DelayedEntry<K, V> createEmpty() {
        return new DelayedEntry<Object, Object>(null, null, 0L, 0);
    }

    public String toString() {
        return "DelayedEntry{key=" + this.key + ", value=" + this.value + ", storeTime=" + this.storeTime + ", partitionId=" + this.getPartitionId() + '}';
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

