/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;

public class ClearExpiredOperation
extends AbstractOperation
implements PartitionAwareOperation {
    private int expirationPercentage;

    public ClearExpiredOperation(int expirationPercentage) {
        this.expirationPercentage = expirationPercentage;
    }

    @Override
    public void run() throws Exception {
        MapService mapService = (MapService)this.getService();
        PartitionContainer partitionContainer = mapService.getPartitionContainer(this.getPartitionId());
        ConcurrentMap<String, RecordStore> recordStores = partitionContainer.getMaps();
        boolean isOwnerPartition = this.isOwner();
        for (RecordStore recordStore : recordStores.values()) {
            if (recordStore.size() <= 0 || !recordStore.isExpirable()) continue;
            recordStore.evictExpiredEntries(this.expirationPercentage, isOwnerPartition);
        }
    }

    private boolean isOwner() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address owner = nodeEngine.getPartitionService().getPartitionOwner(this.getPartitionId());
        return nodeEngine.getThisAddress().equals(owner);
    }

    @Override
    public void afterRun() throws Exception {
        MapService mapService = (MapService)this.getService();
        PartitionContainer partitionContainer = mapService.getPartitionContainer(this.getPartitionId());
        partitionContainer.setHasRunningCleanup(false);
        partitionContainer.setLastCleanupTime(Clock.currentTimeMillis());
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ClearExpiredOperation{}";
    }
}

