/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.eviction.AbstractReachabilityHandler;
import com.hazelcast.map.record.Record;

class TTLReachabilityHandler
extends AbstractReachabilityHandler {
    @Override
    public Record handle(Record record, long criteria, long time) {
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long creationTime = record.getCreationTime();
        assert (ttl > 0L) : String.format("wrong ttl %d", ttl);
        assert (creationTime > 0L) : String.format("wrong creationTime %d", creationTime);
        assert (time > 0L) : String.format("wrong time %d", time);
        assert (time >= creationTime) : String.format("time >= lastUpdateTime (%d >= %d)", time, creationTime);
        boolean result = time - creationTime >= ttl;
        return result ? null : record;
    }

    @Override
    public short niceNumber() {
        return 0;
    }
}

