/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.eviction.IdleReachabilityHandler;
import com.hazelcast.map.eviction.ReachabilityHandler;
import com.hazelcast.map.eviction.ReachabilityHandlerChain;
import com.hazelcast.map.eviction.TTLReachabilityHandler;
import java.util.concurrent.TimeUnit;

public final class ReachabilityHandlers {
    private ReachabilityHandlers() {
    }

    public static ReachabilityHandlerChain newHandlerChain(MapContainer container) {
        return ReachabilityHandlers.newInstance(container);
    }

    private static ReachabilityHandlerChain newInstance(MapContainer container) {
        MapConfig config = container.getMapConfig();
        ReachabilityHandlerChain reachabilityHandlerChain = new ReachabilityHandlerChain(new ReachabilityHandler[0]);
        if ((long)config.getMaxIdleSeconds() > 0L) {
            reachabilityHandlerChain.addHandler(new IdleReachabilityHandler(MapService.convertTime(config.getMaxIdleSeconds(), TimeUnit.SECONDS)));
        }
        reachabilityHandlerChain.addHandler(new TTLReachabilityHandler());
        return reachabilityHandlerChain;
    }
}

