/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.logging.SystemLogRecord;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import java.util.LinkedList;
import java.util.List;

public class GetSystemWarningsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 20;
    }

    @Override
    public Object readResponse(JsonObject in) {
        LinkedList<SystemLogRecord> list = new LinkedList<SystemLogRecord>();
        String node = in.get("node").asString();
        JsonArray logs = in.get("logs").asArray();
        for (JsonValue log : logs) {
            SystemLogRecord systemLogRecord = new SystemLogRecord();
            systemLogRecord.fromJson(log.asObject());
            systemLogRecord.setNode(node);
            list.add(systemLogRecord);
        }
        return list;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        List<SystemLogRecord> logBundle = mcs.getHazelcastInstance().node.getSystemLogService().getSystemWarnings();
        Address address = mcs.getHazelcastInstance().node.getThisAddress();
        result.add("node", address.getHost() + ":" + address.getPort());
        JsonArray logs = new JsonArray();
        for (SystemLogRecord systemLogRecord : logBundle) {
            logs.add(systemLogRecord.toJson());
        }
        result.add("logs", logs);
        root.add("result", result);
    }

    @Override
    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public void fromJson(JsonObject json) {
    }
}

