/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfigReadOnly;

public class NearCacheConfig {
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = "LRU";
    public static final InMemoryFormat DEFAULT_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private int timeToLiveSeconds = 0;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = "LRU";
    private int maxIdleSeconds = 0;
    private boolean invalidateOnChange = true;
    private InMemoryFormat inMemoryFormat = DEFAULT_MEMORY_FORMAT;
    private String name = "default";
    private NearCacheConfigReadOnly readOnly;
    private boolean cacheLocalEntries;

    public NearCacheConfig() {
    }

    public NearCacheConfig(int timeToLiveSeconds, int maxSize, String evictionPolicy, int maxIdleSeconds, boolean invalidateOnChange, InMemoryFormat inMemoryFormat) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxSize = maxSize;
        this.evictionPolicy = evictionPolicy;
        this.maxIdleSeconds = maxIdleSeconds;
        this.invalidateOnChange = invalidateOnChange;
        this.inMemoryFormat = inMemoryFormat;
    }

    public NearCacheConfig(NearCacheConfig config) {
        this.name = config.getName();
        this.evictionPolicy = config.getEvictionPolicy();
        this.inMemoryFormat = config.getInMemoryFormat();
        this.invalidateOnChange = config.isInvalidateOnChange();
        this.maxIdleSeconds = config.getMaxIdleSeconds();
        this.maxSize = config.getMaxSize();
        this.timeToLiveSeconds = config.getTimeToLiveSeconds();
        this.cacheLocalEntries = config.isCacheLocalEntries();
    }

    public NearCacheConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new NearCacheConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public NearCacheConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public NearCacheConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public NearCacheConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public NearCacheConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public NearCacheConfig setInvalidateOnChange(boolean invalidateOnChange) {
        this.invalidateOnChange = invalidateOnChange;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public NearCacheConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public boolean isCacheLocalEntries() {
        return this.cacheLocalEntries;
    }

    public NearCacheConfig setCacheLocalEntries(boolean cacheLocalEntries) {
        this.cacheLocalEntries = cacheLocalEntries;
        return this;
    }

    public NearCacheConfig setInMemoryFormat(String inMemoryFormat) {
        this.inMemoryFormat = InMemoryFormat.valueOf(inMemoryFormat);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NearCacheConfig{");
        sb.append("timeToLiveSeconds=").append(this.timeToLiveSeconds);
        sb.append(", maxSize=").append(this.maxSize);
        sb.append(", evictionPolicy='").append(this.evictionPolicy).append('\'');
        sb.append(", maxIdleSeconds=").append(this.maxIdleSeconds);
        sb.append(", invalidateOnChange=").append(this.invalidateOnChange);
        sb.append(", inMemoryFormat=").append((Object)this.inMemoryFormat);
        sb.append(", cacheLocalEntries=").append(this.cacheLocalEntries);
        sb.append('}');
        return sb.toString();
    }
}

