/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.list;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionItem;
import com.hazelcast.collection.list.ListContainer;
import com.hazelcast.collection.list.ListSetBackupOperation;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ListSetOperation
extends CollectionBackupAwareOperation {
    private int index;
    private Data value;
    private long itemId = -1L;
    private long oldItemId = -1L;

    public ListSetOperation() {
    }

    public ListSetOperation(String name, int index, Data value) {
        super(name);
        this.index = index;
        this.value = value;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new ListSetBackupOperation(this.name, this.oldItemId, this.itemId, this.value);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.LIST_SET;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        ListContainer container = this.getOrCreateListContainer();
        this.itemId = container.nextId();
        CollectionItem item = container.set(this.index, this.itemId, this.value);
        this.oldItemId = item.getItemId();
        this.response = item.getValue();
    }

    @Override
    public void afterRun() throws Exception {
        this.publishEvent(ItemEventType.REMOVED, (Data)this.response);
        this.publishEvent(ItemEventType.ADDED, this.value);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        this.value = new Data();
        this.value.readData(in);
    }
}

