/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientReAuthOperation;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.impl.SerializableCollection;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class AuthenticationRequest
extends CallableClientRequest {
    private Credentials credentials;
    private ClientPrincipal principal;
    private boolean reAuth;
    private boolean firstConnection;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(Credentials credentials) {
        this.credentials = credentials;
    }

    public AuthenticationRequest(Credentials credentials, ClientPrincipal principal) {
        this.credentials = credentials;
        this.principal = principal;
    }

    public Object call() throws Exception {
        boolean authenticated = this.authenticate();
        if (authenticated) {
            return this.handleAuthenticated();
        }
        return this.handleUnauthenticated();
    }

    private boolean authenticate() {
        boolean authenticated;
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        Connection connection = this.endpoint.getConnection();
        ILogger logger = clientEngine.getLogger(this.getClass());
        if (this.credentials == null) {
            authenticated = false;
            logger.severe("Could not retrieve Credentials object!");
        } else if (clientEngine.getSecurityContext() != null) {
            authenticated = this.authenticate(clientEngine.getSecurityContext());
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            authenticated = this.authenticate(usernamePasswordCredentials);
        } else {
            authenticated = false;
            logger.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        logger.log(authenticated ? Level.INFO : Level.WARNING, "Received auth from " + connection + ", " + (authenticated ? "successfully authenticated" : "authentication failed"));
        return authenticated;
    }

    private boolean authenticate(UsernamePasswordCredentials credentials) {
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        GroupConfig groupConfig = clientEngine.getConfig().getGroupConfig();
        String nodeGroupName = groupConfig.getName();
        String nodeGroupPassword = groupConfig.getPassword();
        boolean usernameMatch = nodeGroupName.equals(credentials.getUsername());
        boolean passwordMatch = nodeGroupPassword.equals(credentials.getPassword());
        return usernameMatch && passwordMatch;
    }

    private boolean authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return true;
        }
        catch (LoginException e) {
            ILogger logger = this.clientEngine.getLogger(this.getClass());
            logger.warning(e);
            return false;
        }
    }

    private Object handleUnauthenticated() {
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        clientEngine.getEndpointManager().removeEndpoint(this.endpoint.getConnection());
        return new AuthenticationException("Invalid credentials!");
    }

    private Object handleAuthenticated() {
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        if (this.principal != null && this.reAuth) {
            this.principal = new ClientPrincipal(this.principal.getUuid(), clientEngine.getLocalMember().getUuid());
            this.reAuthLocal();
            Collection<MemberImpl> members = clientEngine.getClusterService().getMemberList();
            for (MemberImpl member : members) {
                if (member.localMember()) continue;
                ClientReAuthOperation op = new ClientReAuthOperation(this.principal.getUuid(), this.firstConnection);
                this.operationService.send(op, member.getAddress());
            }
        }
        if (this.principal == null) {
            this.principal = new ClientPrincipal(this.endpoint.getUuid(), clientEngine.getLocalMember().getUuid());
        }
        this.endpoint.authenticated(this.principal, this.credentials, this.firstConnection);
        clientEngine.bind(this.endpoint);
        return new SerializableCollection(this.serializationService.toData(clientEngine.getThisAddress()), this.serializationService.toData(this.principal));
    }

    private void reAuthLocal() {
        Set<ClientEndpoint> endpoints = this.clientEngine.getEndpointManager().getEndpoints(this.principal.getUuid());
        for (ClientEndpoint endpoint : endpoints) {
            endpoint.authenticated(this.principal);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public void setReAuth(boolean reAuth) {
        this.reAuth = reAuth;
    }

    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    public void setFirstConnection(boolean firstConnection) {
        this.firstConnection = firstConnection;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writePortable("credentials", (Portable)((Object)this.credentials));
        if (this.principal != null) {
            writer.writePortable("principal", this.principal);
        } else {
            writer.writeNullPortable("principal", ClientPortableHook.ID, 3);
        }
        writer.writeBoolean("reAuth", this.reAuth);
        writer.writeBoolean("firstConnection", this.firstConnection);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.credentials = (Credentials)reader.readPortable("credentials");
        this.principal = (ClientPrincipal)reader.readPortable("principal");
        this.reAuth = reader.readBoolean("reAuth");
        this.firstConnection = reader.readBoolean("firstConnection");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

