/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.client.AwaitRequest;
import com.hazelcast.concurrent.lock.client.BeforeAwaitRequest;
import com.hazelcast.concurrent.lock.client.SignalRequest;
import com.hazelcast.core.ICondition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ClientConditionProxy
extends ClientProxy
implements ICondition {
    private final String conditionId;
    private final ClientLockProxy lockProxy;
    private volatile Data key;
    private final InternalLockNamespace namespace;

    public ClientConditionProxy(String instanceName, ClientLockProxy clientLockProxy, String name, ClientContext ctx) {
        super(instanceName, "hz:impl:lockService", clientLockProxy.getName());
        this.setContext(ctx);
        this.lockProxy = clientLockProxy;
        this.namespace = new InternalLockNamespace(this.lockProxy.getName());
        this.conditionId = name;
        this.key = this.toData(this.lockProxy.getName());
    }

    @Override
    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public void awaitUninterruptibly() {
        try {
            this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long start = System.nanoTime();
        this.await(nanosTimeout, TimeUnit.NANOSECONDS);
        long end = System.nanoTime();
        return end - start;
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long threadId = ThreadUtil.getThreadId();
        this.beforeAwait(threadId);
        return this.doAwait(time, unit, threadId);
    }

    private void beforeAwait(long threadId) {
        BeforeAwaitRequest request = new BeforeAwaitRequest(this.namespace, threadId, this.conditionId, this.key);
        this.invoke(request);
    }

    private boolean doAwait(long time, TimeUnit unit, long threadId) throws InterruptedException {
        long timeoutInMillis = unit.toMillis(time);
        AwaitRequest awaitRequest = new AwaitRequest(this.namespace, this.lockProxy.getName(), timeoutInMillis, threadId, this.conditionId);
        Boolean result = (Boolean)this.invoke(awaitRequest);
        return result;
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        long until = deadline.getTime();
        long timeToDeadline = until - Clock.currentTimeMillis();
        return this.await(timeToDeadline, TimeUnit.MILLISECONDS);
    }

    @Override
    public void signal() {
        this.signal(false);
    }

    @Override
    public void signalAll() {
        this.signal(true);
    }

    private void signal(boolean all) {
        SignalRequest request = new SignalRequest(this.namespace, this.lockProxy.getName(), ThreadUtil.getThreadId(), this.conditionId, all);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.key);
    }
}

